package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ColumnWithCaption extends DemoChartBase {
	private static final long serialVersionUID = -4047412468095117174L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Chart with a caption");
		chartOptions.getSubtitle().setText("This is the subtitle");
		
		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Apples", "Pears", "Bananas", "Oranges"));
		chartOptions.getXAxis().add(xAxi);

		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("Fruits");
		seriesColumn.setType(SeriesType.COLUMN);
		seriesColumn.setDataAsArrayNumber(Arrays.asList(1, 4, 3, 5));
		chartOptions.getSeries().add(seriesColumn);
		
		chartOptions.getCaption().setText("<b>The caption renders in the bottom, and is part of the exported chart.</b><br><em>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</em>");
		
		return highChart;
	}
	
}
