package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesColumnrange;
import com.hyjavacharts.model.highcharts.series.seriescolumnrange.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ColumnRange extends DemoChartBase {
	private static final long serialVersionUID = -8081231449216438627L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMNRANGE).setInverted(true);
		chartOptions.getTitle().setText("Temperature variation by month");
		chartOptions.getSubtitle().setText("Observed in Vik i Sogn, Norway");

		XAxis xAxi = new XAxis();
		xAxi.setCrosshairAsBoolean(true)
			.setCategories(Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"));
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Temperature ( °C )");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getTooltip().setValueSuffix("°C");
		chartOptions.getPlotOptions().getColumnrange().getDataLabels().setEnabled(true)
			.getFormatter().setFunctionBody("return this.y + '°C';");
		chartOptions.getLegend().setEnabled(false);
		
		SeriesColumnrange seriesColumnrange = new SeriesColumnrange();
		seriesColumnrange.setName("Temperatures");
		seriesColumnrange.setDataAsArrayObject(Arrays.asList(
			new Data().setLow(-9.7).setHigh(9.4),
			new Data().setLow(-8.7).setHigh(6.5),
			new Data().setLow(-3.5).setHigh(9.4),
			new Data().setLow(-1.4).setHigh(19.9),
			new Data().setLow(0.0).setHigh(22.6),
			new Data().setLow(2.9).setHigh(29.5),
			new Data().setLow(9.2).setHigh(30.7),
			new Data().setLow(7.3).setHigh(26.5),
			new Data().setLow(4.4).setHigh(18.0),
			new Data().setLow(-3.1).setHigh(11.4),
			new Data().setLow(-5.2).setHigh(10.4),
			new Data().setLow(-13.5).setHigh(9.8)
			));
		chartOptions.getSeries().add(seriesColumnrange);
		
		return highChart;
	}

}
