package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesColumnpyramid;
import com.hyjavacharts.model.highcharts.series.seriescolumnpyramid.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ColumnPyramid extends DemoChartBase {
	private static final long serialVersionUID = -8930943331745558955L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getChart().setType(ChartType.COLUMNPYRAMID);
		chartOptions.getTitle().setText("The 5 highest pyramids in the World");
		
		chartOptions.setColors(Arrays.asList(
			new Color("#C79D6D"), new Color("#B5927B"), new Color("#CE9B84"), new Color("#B7A58C"), new Color("#C7A58C")));
		
		XAxis xAxis = new XAxis();
		xAxis.setCrosshairAsBoolean(true).setType(AxisType.CATEGORY).getLabels().getStyle().setFontSize("14px");
		xAxis.getTitle().setText(null);
		chartOptions.getXAxis().add(xAxis);

		YAxis yAxis = new YAxis();
		yAxis.setMin(0).getTitle().setText("Height (m)");
		chartOptions.getYAxis().add(yAxis);
		
		chartOptions.getTooltip().setValueSuffix(" m");
		
		SeriesColumnpyramid seriesColumnpyramid = new SeriesColumnpyramid();
		seriesColumnpyramid.setName("Height").setColorByPoint(true).setShowInLegend(false);

		seriesColumnpyramid.setDataAsArrayObject(Arrays.asList(
			new Data().setName("Pyramid of Khufu").setY(138.8),
			new Data().setName("Pyramid of Khafre").setY(136.4),
			new Data().setName("Red Pyramid").setY(104),
			new Data().setName("Bent Pyramid").setY(101.1),
			new Data().setName("Pyramid of the Sun").setY(75)
			));
		chartOptions.getSeries().add(seriesColumnpyramid);
		
		return highChart;
	}

}
