package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.labels.Items;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ColumnLineAndPie extends DemoChartBase {
	private static final long serialVersionUID = -4484842306538016242L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Combination chart");
		
		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Apples", "Oranges", "Pears", "Bananas", "Plums"));
		chartOptions.getXAxis().add(xAxi);
		
		Items item = new Items();
		item.setHtml("Total fruit consumption")
			.getStyle()
				.setCssValue("{ left: '50px', top: '18px', color: (Highcharts.theme && Highcharts.theme.textColor) || 'black' }");
		chartOptions.getLabels().getItems().add(item);
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setType(SeriesType.COLUMN).setName("Jane");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(3, 2, 1, 3, 4));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setType(SeriesType.COLUMN).setName("John");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(2, 3, 5, 7, 6));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setType(SeriesType.COLUMN).setName("Joe");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(4, 3, 3, 9, 0));
		chartOptions.getSeries().add(seriesColumn);

		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setType(SeriesType.SPLINE).setName("Average");
		seriesSpline.getMarker()
			.setLineWidth(2)
			.setFillColor(new Color("white"))
			.getLineColor().setColorValue("Highcharts.getOptions().colors[3]");
		seriesSpline.setDataAsArrayNumber(Arrays.asList(3, 2.67, 3, 6.33, 3.33));
		chartOptions.getSeries().add(seriesSpline);
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setType(SeriesType.PIE)
			.setName("Total consumption")
			.setCenterAsArrayNumber(Arrays.asList(100, 80))
			.setSizeAsNumber(100)
			.setShowInLegend(false)
			.getDataLabels().setEnabled(false);
		seriesPie.setDataAsArrayObject(Arrays.asList(
			new Data().setName("Jane").setY(13).setColor(new Color().setColorValue("Highcharts.getOptions().colors[0]")),
			new Data().setName("John").setY(23).setColor(new Color().setColorValue("Highcharts.getOptions().colors[1]")),
			new Data().setName("Joe").setY(19).setColor(new Color().setColorValue("Highcharts.getOptions().colors[2]"))
			));
		chartOptions.getSeries().add(seriesPie);
		
		return highChart;
	}

}
