package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesBoxplot;
import com.hyjavacharts.model.highcharts.series.SeriesScatter;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class BoxPlot extends DemoChartBase {
	private static final long serialVersionUID = -5084780891234923704L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.BOXPLOT);
		chartOptions.getTitle().setText("Highcharts Box Plot Example");

		chartOptions.getLegend().setEnabled(false);
		
		chartOptions.getXAxisSingle()
			.setCategories(Arrays.asList("1", "2", "3", "4", "5"))
			.getTitle().setText("Experiment No.");

		chartOptions.getYAxisSingle()
			.getTitle().setText("Observations");
		chartOptions.getYAxisSingle()
			.getPlotLinesSingle()
				.setValue(932)
				.setColor(new Color("red"))
				.setWidth(1)
				.getLabel().setText("Theoretical mean: 932")
					.setAlign(HorizontalAlign.CENTER)
					.getStyle().setColor(new Color("gray"));

		SeriesBoxplot seriesBoxplot = new SeriesBoxplot();
		seriesBoxplot.setName("Observations");
		seriesBoxplot.getTooltip().setHeaderFormat("<em>Experiment No {point.key}</em><br/>");
		seriesBoxplot.setDataAsArrayJavaObject(getSeriesData(1));
		chartOptions.getSeries().add(seriesBoxplot);
		
		SeriesScatter seriesScatter = new SeriesScatter();
		seriesScatter.setType(SeriesType.SCATTER)
			.setName("Outlier")
			.setColor(new Color().setColorValue("Highcharts.getOptions().colors[0]"))
			.getMarker()
				.setFillColor(new Color("white"))
				.setLineWidth(1)
				.setLineColor(new Color().setColorValue("Highcharts.getOptions().colors[0]"));
		seriesScatter.getTooltip().setPointFormat("Observation: {point.y}");
		seriesScatter.setDataAsArrayJavaObject(getSeriesData(2));
		chartOptions.getSeries().add(seriesScatter);
				
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Object> getSeriesData(int series) {
		ArrayList<Object> array = new ArrayList<Object>();
		
		if (series == 1) {
	    	array.add(Arrays.asList(760, 801, 848, 895, 965));
	    	array.add(Arrays.asList(733, 853, 939, 980, 1080));
	    	array.add(Arrays.asList(714, 762, 817, 870, 918));
	    	array.add(Arrays.asList(724, 802, 806, 871, 950));
	    	array.add(Arrays.asList(834, 836, 864, 882, 910));
		}
		else {
			array.add(Arrays.asList(0, 644));
	    	array.add(Arrays.asList(4, 718));
	    	array.add(Arrays.asList(4, 951));
	    	array.add(Arrays.asList(4, 969));
		}

    	return array;
    }
}
