package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.TitleAlign;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class BasicColumn extends DemoChartBase {
	private static final long serialVersionUID = -4047412468095117174L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("Monthly Average Rainfall");
		chartOptions.getSubtitle().setText("Source: WorldClimate.com");

		XAxis xAxi = new XAxis();
		xAxi.setCrosshairAsBoolean(true)
			.setCategories(Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"));

		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.setMin(0).getTitle().setText("Population (millions)").setAlign(TitleAlign.HIGH);
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getTooltip()
			.setHeaderFormat("<span style=\"font-size:10px\">{point.key}</span><table>")
			.setPointFormat("<tr><td style=\"color:{series.color};padding:0\">{series.name}: </td>" 
						+ "<td style=\"padding:0\"><b>{point.y:.1f} mm</b></td></tr>")
			.setFooterFormat("</table>")
			.setShared(true)
			.setUseHTML(true);
		
		chartOptions.getPlotOptions().getColumn().setPointPadding(0.2).setBorderWidth(0);
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("Tokyo");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(49.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("New York");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(83.6, 78.8, 98.5, 93.4, 106.0, 84.5, 105.0, 104.3, 91.2, 83.5, 106.6, 92.3));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("London");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(48.9, 38.8, 39.3, 41.4, 47.0, 48.3, 59.0, 59.6, 52.4, 65.2, 59.3, 51.2));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Berlin");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(42.4, 33.2, 34.5, 39.7, 52.6, 75.5, 57.4, 60.4, 47.6, 39.1, 46.8, 51.1));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}

}
