package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Stacking;
import com.hyjavacharts.model.highcharts.series.SeriesBar;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class BarWithNegativeStack extends DemoChartBase {
	private static final long serialVersionUID = -3292199106376851760L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.BAR);
		chartOptions.getTitle().setText("Population pyramid for Germany, 2015");
		chartOptions.getSubtitle().setText("Source: <a href=\"http://populationpyramid.net/germany/2015/\">Population Pyramids of the World from 1950 to 2100</a>");
		
		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("0-4", "5-9", "10-14", "15-19",
				"20-24", "25-29", "30-34", "35-39", "40-44",
				"45-49", "50-54", "55-59", "60-64", "65-69",                  
				"70-74", "75-79", "80-84", "85-89", "90-94",
				"95-99", "100 + "));
		xAxi.setReversed(false).getLabels().setStep(1);
		chartOptions.getXAxis().add(xAxi);
		
		xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("0-4", "5-9", "10-14", "15-19",
				"20-24", "25-29", "30-34", "35-39", "40-44",
				"45-49", "50-54", "55-59", "60-64", "65-69",                  
				"70-74", "75-79", "80-84", "85-89", "90-94",
				"95-99", "100 + "));
		xAxi.setOpposite(true).setReversed(false).setLinkedTo(0).getLabels().setStep(1);
		chartOptions.getXAxis().add(xAxi);
		
		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText(null);
		yAxi.getLabels().getFormatter().setFunctionBody("return Math.abs(this.value) + '%';");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getPlotOptions().getBar().setStacking(Stacking.NORMAL);
		
		chartOptions.getTooltip().getFormatter().setFunctionBody("return \"<b>\" + this.series.name + \", age \" "
				+ "+ this.point.category + \"</b><br/>\" +\r\n" + 
				"\"Population: \" + Highcharts.numberFormat(Math.abs(this.point.y), 0);");
		
		SeriesBar seriesBar = new SeriesBar();
		seriesBar.setName("Male");
		seriesBar.setDataAsArrayNumber(Arrays.asList(
				-2.2, -2.2, -2.3, -2.5, -2.7, -3.1, -3.2,
				-3.0, -3.2, -4.3, -4.4, -3.6, -3.1, -2.4,    	          
				-2.5, -2.3, -1.2, -0.6, -0.2, -0.0, -0.0));
		chartOptions.getSeries().add(seriesBar);
		
		seriesBar = new SeriesBar();
		seriesBar.setName("Female");
		seriesBar.setDataAsArrayNumber(Arrays.asList(
				2.1, 2.0, 2.2, 2.4, 2.6, 3.0, 3.1, 2.9,
				3.1, 4.1, 4.3, 3.6, 3.4, 2.6, 2.9, 2.9,
				1.8, 1.2, 0.6, 0.1, 0.0));
		chartOptions.getSeries().add(seriesBar);
		
		return highChart;
	}

}
