package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class AreaWithMissingPoints extends DemoChartBase {
	private static final long serialVersionUID = -7468449398511869471L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.AREA);
		
		chartOptions.getTitle().setText("Fruit consumption *");
		chartOptions.getSubtitle()
			.setAlign(HorizontalAlign.RIGHT)
			.setVerticalAlign(VerticalAlign.BOTTOM)
			.setText("* Jane\\'s banana consumption is unknown");

		chartOptions.getLegend()
			.setLayout(Layout.VERTICAL)
			.setAlign(HorizontalAlign.LEFT)
			.setVerticalAlign(VerticalAlign.TOP)
			.setX(100)
			.setY(70)
			.setFloating(true)
			.setBorderWidth(1)
			.setBackgroundColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'"));
		
		chartOptions.getXAxisSingle().setCategories(
				Arrays.asList("Apples", "Pears", "Oranges", "Bananas", "Grapes", "Plums", "Strawberries", "Raspberries"));
		
		chartOptions.getYAxisSingle().getTitle().setText("Y-Axis");
		chartOptions.getYAxisSingle().getLabels().getFormatter().setFunctionBody("return this.value;");

		chartOptions.getTooltip().getFormatter().setFunctionBody("return '<b>' + this.series.name + '</b><br/>' + this.x + ': ' + this.y;");

		chartOptions.getPlotOptions().getArea().setFillOpacity(0.5);
	
		chartOptions.getCredits().setEnabled(false);
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setName("John");
		seriesArea.setDataAsArrayNumber(Arrays.asList(0, 1, 4, 4, 5, 2, 3, 7));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("Jane");
		seriesArea.setDataAsArrayNumber(Arrays.asList(1, 0, 3, null, 3, 1, 2, 1));
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}

}
