package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesAreaspline;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class AreaSpline extends DemoChartBase {
	private static final long serialVersionUID = 2227624938609309810L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.AREASPLINE);
		
		chartOptions.getTitle().setText("Average fruit consumption during one week");

		chartOptions.getLegend()
			.setLayout(Layout.VERTICAL)
			.setAlign(HorizontalAlign.LEFT)
			.setVerticalAlign(VerticalAlign.TOP)
			.setX(150)
			.setY(100)
			.setFloating(true)
			.setBorderWidth(1)
			.setBackgroundColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'"));
		
		chartOptions.getXAxisSingle().setCategories(
					Arrays.asList("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"));
		chartOptions.getXAxisSingle()
			.getPlotBandsSingle()
				.setFrom(4.5)
				.setTo(6.5)
				.setColor(new Color().setRGBA(68, 170, 213, .2));
		
		chartOptions.getYAxisSingle()
			.getTitle().setText("Fruit units");

		chartOptions.getTooltip().setShared(true).setValueSuffix(" units");
		chartOptions.getCredits().setEnabled(false);
		chartOptions.getPlotOptions().getAreaspline().setFillOpacity(0.5);
		
		SeriesAreaspline seriesAreaspline = new SeriesAreaspline();
		seriesAreaspline.setName("John");
		seriesAreaspline.setDataAsArrayNumber(Arrays.asList(3, 4, 3, 5, 4, 10, 12));
		chartOptions.getSeries().add(seriesAreaspline);
		
		seriesAreaspline = new SeriesAreaspline();
		seriesAreaspline.setName("Jane");
		seriesAreaspline.setDataAsArrayNumber(Arrays.asList(1, 3, 4, 3, 3, 5, 4));
		chartOptions.getSeries().add(seriesAreaspline);
		
		return highChart;
	}

}
