package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesArearange;
import com.hyjavacharts.model.highcharts.series.SeriesLine;
import com.webonlineapp.hyjavachartsdemo7flow.chartdata.AreaRangeAndLineData;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class AreaRangeAndLine extends DemoChartBase {
	private static final long serialVersionUID = 2766439177573884974L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("July temperatures");

		chartOptions.getXAxisSingle().setType(AxisType.DATETIME);
		
		chartOptions.getYAxisSingle().getTitle().setText(null);

		chartOptions.getTooltip().setCrosshairs(true).setShared(true).setValueSuffix("°C");
		
		AreaRangeAndLineData seriesData = new AreaRangeAndLineData();

		SeriesLine seriesLine = new SeriesLine();
		seriesLine.setName("Temperature")
			.setZIndex(1).getMarker()
			.setFillColor(new Color("white"))
			.setLineWidth(2)
			.setLineColor(new Color().setColorValue("Highcharts.getOptions().colors[0]"));
		seriesLine.setDataAsArrayJavaObject(seriesData.getSeriesData(1));
		chartOptions.getSeries().add(seriesLine);
		
		SeriesArearange seriesArearange = new SeriesArearange();
		seriesArearange.setType(SeriesType.AREARANGE)
			.setName("Range")
			.setLineWidth(0)
			.setLinkedTo(":previous")
			.setColor(new Color().setColorValue("Highcharts.getOptions().colors[0]"))
			.setFillOpacity(0.3)
			.setZIndex(0)
			.getMarker().setEnabled(false);
		seriesArearange.setDataAsArrayJavaObject(seriesData.getSeriesData(2));
		chartOptions.getSeries().add(seriesArearange);
		
		return highChart;
	}

}
