package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesArearange;
import com.webonlineapp.hyjavachartsdemo7flow.chartdata.AreaRangeData;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class AreaRange extends DemoChartBase {
	private static final long serialVersionUID = -6928304268649718282L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.AREARANGE)
			.setZoomType(ZoomType.X);
		
		chartOptions.getTitle().setText("Temperature variation by day");

		chartOptions.getXAxisSingle().setType(AxisType.DATETIME);
		
		chartOptions.getYAxisSingle().getTitle().setText(null);

		chartOptions.getTooltip().setCrosshairs(true).setShared(true).setValueSuffix("°C");
		chartOptions.getLegend().setEnabled(false);
		
		SeriesArearange seriesArearange = new SeriesArearange();
		seriesArearange.setName("Temperatures");
		seriesArearange.setDataAsArrayJavaObject(new AreaRangeData().getSeriesData());
		chartOptions.getSeries().add(seriesArearange);
		
		return highChart;
	}

}
