package com.webonlineapp.hyjavachartsdemo7flow.util;

import java.io.File;
import java.net.URL;

import javax.servlet.ServletContext;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletRequest;

/**
 *  
 */
public class ServletUtil {

	/**
	 * Usage: URL url = GeneralUtil.getServletContext().getResource("/docroot/reports/abc.xml");
	 * @return
	 */
    static public ServletContext getServletContext() {
        return VaadinServlet.getCurrent().getServletContext();
    }
 
    /**
     * Usage: Resource res = new FileResource(new File(GeneralUtil.getBasePath() + "/docroot/abc.pdf"));
     * @return
     */
//    static public String getBasePath() {
//        return VaadinService.getCurrent().getBaseDirectory().getPath();
//    }
    
    /**
     * 
     * @return
     */
    static public String getHost() {
        //return UI.getCurrent().getPage().getLocation().getHost();
    	
    	// TEMP solution - waiting on Vaadin to implement in flow
    	String loc = getLocation();
    	
    	int start = loc.indexOf("://") + 3;
    	int end = loc.indexOf("/", start);
    	
     	return loc.substring(start, end);
     }
    
    /**
     * 
     * @return
     */
//    static public int getPort() {
//        return UI.getCurrent().getPage().getLocation().getPort();
//    }
    
    
    // NEW FOR FLOW
    
    /**
     * 
     * @return
     */
    public static String getLocation() {
        VaadinServletRequest request = (VaadinServletRequest) VaadinService.getCurrentRequest();

        return request.getRequestURL().toString();
    }
    
    
    /**
	 * 
	 * @param servlet
	 * @return
	 */
    public static File getBaseDirectory(VaadinServlet servlet) {
        final String realPath = getResourcePath(servlet.getServletContext(), "/");
        
        if (realPath == null) {
            return null;
        }
        
        return new File(realPath);
    }
    
    /**
     * 
     * @return
     */
    public static String getContextPath() {
    	return VaadinServlet.getCurrent().getServletContext().getContextPath();
    }
    
    /**
     * 
     * @param servletContext
     * @param path
     * @return
     */
    private static String getResourcePath(ServletContext servletContext, String path) {
		String resultPath = null;
		
		resultPath = servletContext.getRealPath(path);

		if (resultPath != null) {
			return resultPath;
		} 
		else {
			try {
				final URL url = servletContext.getResource(path);
				resultPath = url.getFile();
			}
			catch (final Exception e) {

			}
		}

		return resultPath;
    }
    
}
