package com.webonlineapp.hyjavachartsdemo7flow.util;

import com.vaadin.flow.component.UI;

public class JavascriptUtil {
	public static final String HIGHCHARTS_SERIES_HOVER = "\".highcharts-series-hover path { stroke: rgb(255, 66, 66);  stroke-width: 2px; }\"";
	
	
	/**
	 * 
	 * @param rule
	 * @param index
	 */
	public static void addStyleSheetRule(String rule, int index) {
		String add = 
				"var stylesheet = document.styleSheets[(document.styleSheets.length - 1)];" + 
				"for( var i in document.styleSheets ){" + 
				"	if( document.styleSheets[i].href && document.styleSheets[i].href.indexOf(\"styles.css\") ) {" + 
				"		stylesheet = document.styleSheets[i];" + 
				"		break;" + 
				"	}" + 
				"}"  + 
				"stylesheet.insertRule(" + rule + ", " + index + ");"
				;
		
		UI.getCurrent().getPage().executeJs(add);
	}
	
	/**
	 * 
	 * @param index
	 */
	public static void removeStyleSheetRule(int index) {
		String remove = 
				"var stylesheet = document.styleSheets[(document.styleSheets.length - 1)];" + 
				"for( var i in document.styleSheets ){" + 
				"	if( document.styleSheets[i].href && document.styleSheets[i].href.indexOf(\"styles.css\") ) {" + 
				"		stylesheet = document.styleSheets[i];" + 
				"		break;" + 
				"	}" + 
				"}"  + 
				"stylesheet.deleteRule(" + index + ");"
				;
		UI.getCurrent().getPage().executeJs(remove);
	}
	
	/**
	 * 
	 */
	public static void triggerResize() {
		UI.getCurrent().getPage().executeJs("window.dispatchEvent(new Event('resize'));");
	}
		
}
