package com.webonlineapp.hyjavachartsdemo7flow.services;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.UriBuilder;

import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

import com.webonlineapp.hyjavachartsdemo7flow.util.ServletUtil;

public class RestService {
	private String webServiceURI = "https://localhost/app/HyJavaChartsServices";	// dev, test, prod hosts
	private boolean trusted;
	
	
	/**
	 * 
	 */
	public RestService() {
		if (ServletUtil.getHost().equals("localhost")) {
			webServiceURI = "http://localhost/HyJavaChartsServices";	// local dev host
		}
		
		if (webServiceURI.contains("localhost")) {
			trusted = true;
		}
	}
	
	/**
	 * No authentication.
	 * @return
	 */
	public WebTarget getWebTarget() {
		return getWebTarget(null, null);
	}
	
	/**
	 * User name and password authentication.
	 * @param authFeature
	 * @return
	 */
	public WebTarget getWebTarget(HttpAuthenticationFeature authFeature) {
		return getWebTarget(authFeature, null);
	}
	
	/**
	 * Token authentication.
	 * @param tokenFeature
	 * @return
	 */
	public WebTarget getWebTarget(Feature tokenFeature) {
		return getWebTarget(null, tokenFeature);
	}
	
	/**
	 * 
	 * @param authFeature
	 * @param tokenFeature
	 * @return
	 */
	private WebTarget getWebTarget(HttpAuthenticationFeature authFeature, Feature tokenFeature) {
		Client client = null;
		
		if (trusted) {
			client = getTrustedClient();
		}
		else {
			client = getClient();
		}
		
		if (authFeature != null) {
			client.register(authFeature);
		}
		
		if (tokenFeature != null) {
			client.register(tokenFeature);
		}
			
		URI serviceURI = UriBuilder.fromUri(webServiceURI).build();
		WebTarget webTarget = client.target(serviceURI);
		
		return webTarget;
	}
	
	/**
	 * 
	 * @return
	 */
	public  Client getClient() { 
		ClientConfig clientConfig = new ClientConfig();
		
		return ClientBuilder.newClient(clientConfig);
	}
	
	/**
	 * 
	 * @return
	 */
	public  Client getTrustedClient() { 
        try { 
            TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() { 
	            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {} 

                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {} 

                public X509Certificate[] getAcceptedIssuers() { 
                	return new X509Certificate[0]; 
                } 
            
            }}; 
            
            final SSLContext sslContext = SSLContext.getInstance("TLS"); 
            sslContext.init(null, trustAllCerts, new java.security.SecureRandom()); 
                
            final HostnameVerifier allHostsValid = new HostnameVerifier() { 
                public boolean verify(String hostname, SSLSession session) { 
                	return true; 
                }	
            };
            
            ClientBuilder clientBuilder = ClientBuilder.newBuilder(); 
            ClientConfig config = new ClientConfig(); 
            return clientBuilder.sslContext(sslContext).hostnameVerifier(allHostsValid).withConfig(config).build();
        } 
        
        catch (NoSuchAlgorithmException e) { 
        	e.printStackTrace(); 
        }
        
        catch (KeyManagementException e) { 
        	e.printStackTrace(); 
        } 
        
        return null;
	} 
	
	/**
	 * 
	 * @return
	 */
	public static String getURI() {
		String host = ServletUtil.getHost();
		
		if (host.equals("localhost")) {
			return "http://localhost/HyJavaChartsServices";
		}
		else {
			return "https://" + host + "/app/HyJavaChartsServices";
		}
	}

}
