package com.webonlineapp.hyjavachartsdemo7flow.exportserver;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;

import com.webonlineapp.hyjavachartsdemo7flow.Properties;
import com.webonlineapp.hyjavachartsdemo7flow.util.ServletUtil;

public class ExportServer {

	/**
	 * Create a chart jpg file using the Highcharts export server.
	 * 
	 */
	public InputStream createChart(String globalOptionsJs, String chartOptionsJs) throws Exception {
        URL url = new URL(getExportServerURL());
        
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestProperty("accept", "text/html, application/xhtml+xml, image/jxr, */*");
        conn.setRequestProperty("accept-language", "en-GB");
        conn.setRequestProperty("User-Agent","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.10240");
        conn.setRequestProperty("accept-encoding", "gzip, deflate");
		
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        
        // Get POST data for the request
        byte[] postDataBytes = getPostData(globalOptionsJs, chartOptionsJs);
        
        conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
        conn.setDoOutput(true);
        conn.getOutputStream().write(postDataBytes);
         
        return conn.getInputStream();
    }
	
	/**
	 * Return Highcharts export server POST params for the request.
	 * As per https://www.highcharts.com/docs/export-module/export-module-overview
	 * also https://github.com/highcharts/node-export-server
	 * 
	 * @param globalOptionsJs
	 * @param chartOptionsJs
	 * @return
	 * @throws Exception
	 */
	private byte[] getPostData(String globalOptionsJs, String chartOptionsJs) throws Exception {
		Map<String, Object> params = new LinkedHashMap<>();

        params.put("type", "image/jpeg");	//application/pdf  image/png   image/jpeg     image/svg+xml
        params.put("constr", "Chart");
        params.put("width", 700);
        params.put("infile", chartOptionsJs);
        params.put("globalOptions", globalOptionsJs);

        StringBuilder postData = new StringBuilder();
        for (Map.Entry<String,Object> param : params.entrySet()) {
            if (postData.length() != 0) postData.append('&');
            postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
            postData.append('=');
            postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        
        byte[] postDataBytes = postData.toString().getBytes("UTF-8");
        
        return postDataBytes;
	}
	
	/**
	 * 
	 * @return
	 */
	public static String getExportServerURL() {
		String host = ServletUtil.getHost();
		
		if (host.equals("localhost")) {
			return Properties.HIGHCHARTS_EXPORT_SERVER_URL_LOCAL;
		}
		else {
			return Properties.HIGHCHARTS_EXPORT_SERVER_URL;
		}
	}

}
