package com.webonlineapp.hyjavachartsdemo7flow.exportserver;

import java.io.InputStream;

import javax.xml.transform.stream.StreamSource;

import com.vaadin.flow.server.InputStreamFactory;



public class ChartImageSource extends StreamSource implements InputStreamFactory {
	private static final long serialVersionUID = -548536530607797650L;
	
	private String globalOptionsJs;
	private String chartOptionsJs;
	
	
	/**
	 * 
	 * @param globalOptionsJs
	 * @param chartOptionsJs
	 */
	public ChartImageSource(String globalOptionsJs, String chartOptionsJs) {
		this.globalOptionsJs = globalOptionsJs;
		this.chartOptionsJs = chartOptionsJs;
	}
	
	/**
	 * 
	 */
	@Override
	public InputStream createInputStream() {
		try {
			InputStream chartInputStream = new ExportServer().createChart(globalOptionsJs, chartOptionsJs);
			return chartInputStream;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
    
}
