package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesWordcloud;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class WordCloud extends DemoChartBase {
	private static final long serialVersionUID = -357736558741605052L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Wordcloud of Lorem Ipsum");
		
		SeriesWordcloud seriesWordcloud = new SeriesWordcloud();
		seriesWordcloud.setType(SeriesType.WORDCLOUD);
		seriesWordcloud.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesWordcloud);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Object> getSeriesData() {
		String text = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean bibendum erat ac justo sollicitudin, quis lacinia ligula fringilla. Pellentesque hendrerit, nisi vitae posuere condimentum, lectus urna accumsan libero, rutrum commodo mi lacus pretium erat. Phasellus pretium ultrices mi sed semper. Praesent ut tristique magna. Donec nisl tellus, sagittis ut tempus sit amet, consectetur eget erat. Sed ornare gravida lacinia. Curabitur iaculis metus purus, eget pretium est laoreet ut. Quisque tristique augue ac eros malesuada, vitae facilisis mauris sollicitudin. Mauris ac molestie nulla, vitae facilisis quam. Curabitur placerat ornare sem, in mattis purus posuere eget. Praesent non condimentum odio. Nunc aliquet, odio nec auctor congue, sapien justo dictum massa, nec fermentum massa sapien non tellus. Praesent luctus eros et nunc pretium hendrerit. In consequat et eros nec interdum. Ut neque dui, maximus id elit ac, consequat pretium tellus. Nullam vel accumsan lorem.";
		text = text.replace(",", "").replace(".", "");
		text = text.replace(" ", ",");
		String[] textAray = text.split(",");
		
		SortedMap<String, Integer> words = new TreeMap<String, Integer>();
		
		for (int i = 0; i < textAray.length; i++) {
			Integer wordCount = words.get(textAray[i]);
			
			if (wordCount == null) {
				wordCount = new Integer(1);
				words.put(textAray[i], wordCount);
			}
			else {
				wordCount = wordCount.intValue() + 1;
				words.remove(textAray[i]);
				words.put(textAray[i], wordCount);
			}
		}
		
		ArrayList<Object> array = new ArrayList<Object>();
		for (String word : words.keySet()) {
			array.add(Arrays.asList(word, words.get(word)));
		}

    	return array;
    }
	
}
