package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesLine;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class WithDataLabels extends DemoChartBase {
	private static final long serialVersionUID = 3297261254385181897L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getChart().setType(ChartType.LINE);
		chartOptions.getTitle().setText("Monthly Average Temperature");
		chartOptions.getSubtitle().setText("Source: WorldClimate.com");
	
		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"));
		chartOptions.getXAxis().add(xAxi);
		
		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Temperature (°C)");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getPlotOptions().getLine().setEnableMouseTracking(false).getDataLabels().setEnabled(true);
		
		SeriesLine seriesLine = new SeriesLine();
		seriesLine.setName("Tokyo");
		seriesLine.setDataAsArrayNumber(Arrays.asList(7.0, 6.9, 9.5, 14.5, 18.4, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6));
		chartOptions.getSeries().add(seriesLine);
		
		seriesLine = new SeriesLine();
		seriesLine.setName("London");
		seriesLine.setDataAsArrayNumber(Arrays.asList(3.9, 4.2, 5.7, 8.5, 11.9, 15.2, 17.0, 16.6, 14.2, 10.3, 6.6, 4.8));
		chartOptions.getSeries().add(seriesLine);
		
		return highChart;
	}

}
