package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import javax.ws.rs.client.WebTarget;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.Annotations;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.annotations.Labels;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.LabelOptionsShape;
import com.hyjavacharts.model.highcharts.constants.PanKey;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class WithAnnotations extends DemoChartBase {
	private static final long serialVersionUID = -3302909719980269818L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.AREA)
			.setZoomType(ZoomType.X)
			.setPanning(true)
			.setPanKey(PanKey.SHIFT);
		
		chartOptions.getTitle().setText("2017 Tour de France Stage 8: Dole - Station des Rousses");
		chartOptions.getSubtitle().setText("An annotated chart in Highcharts");

		Annotations annot = new Annotations();
		annot.getLabelOptions()
			.setBackgroundColor(new Color().setRGBA(255, 255, 255, 0.5))
			.setVerticalAlign(VerticalAlign.TOP)
			.setY(15);
		
		Labels label = new Labels();
		label.setText("Arbois").getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(27.98).setY(255);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("Montrond").getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(45.5).setY(611);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("Mont-sur-Monnet").getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(63).setY(651);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("Bonlieu").setX(-10).getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(84).setY(789);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("Chassal").setX(-10).getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(129.5).setY(382);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("Saint-Claude").setX(-10).getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(159).setY(443);
		annot.getLabels().add(label);
		
		chartOptions.getAnnotations().add(annot);
		
		annot = new Annotations();
		
		label = new Labels();
		label.setText("Col de la Joux").setX(-30).getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(101.44).setY(1026);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("Côte de Viry").getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(138.5).setY(748);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("Montée de la Combe<br>de Laisia Les Molunes").getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(176.4).setY(1202);
		annot.getLabels().add(label);
		
		chartOptions.getAnnotations().add(annot);
		
		annot = new Annotations();
		annot.getLabelOptions().setShape(LabelOptionsShape.CONNECTOR)
			.setAlign(HorizontalAlign.RIGHT)
			.setCrop(true)
			.getStyle()
				.setFontSize("0.8em").setTextOutline("1px white");
		annot.getLabelOptions().setJustify(false);
		
		label = new Labels();
		label.setText("6.1 km climb<br>4.6% on avg.").getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(96.2).setY(783);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("7.6 km climb<br>5.2% on avg.").getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(134.5).setY(540);
		annot.getLabels().add(label);
		
		label = new Labels();
		label.setText("11.7 km climb<br>6.4% on avg.").getPointAsObject().setXAxisAsNumber(0).setYAxisAsNumber(0).setX(172.2).setY(925);
		annot.getLabels().add(label);
		
		chartOptions.getAnnotations().add(annot);
		
		chartOptions.getXAxisSingle().getLabels().setFormat("{value} km");
		chartOptions.getXAxisSingle().setMinRange(5).getTitle().setText("Distance");
		
		chartOptions.getYAxisSingle().setStartOnTick(true).setEndOnTick(false).setMaxPadding(0.35).getTitle().setText(null);
		chartOptions.getYAxisSingle().getLabels().setFormat("{value} m");

		chartOptions.getTooltip()
			.setHeaderFormat("Distance: {point.x:.1f} km<br>")
			.setPointFormat("{point.y} m a. s. l.")
			.setShared(true);
		chartOptions.getLegend().setEnabled(false);
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setName("Elevation")
			.setLineColor(chartOptions.getColors().get(1))
			.setColor(chartOptions.getColors().get(2))
			.setFillOpacity(0.5)
			.setThreshold(null)
			.getMarker().setEnabled(false);
		seriesArea.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Object> getSeriesData() {
		ArrayList<Object> array = new ArrayList<Object>();
		
		// REST service returns CSV elevations data in format kms, elevation
		WebTarget webTarget = new RestService().getWebTarget();
		String elevationsData = webTarget.path("WithAnnotationsCSVData").request().get(String.class);

		String[] dataRows = elevationsData.split("\n");
		
		for(int i = 1; i < dataRows.length; i++) {
			String[] rowElements = dataRows[i].split(",");

			array.add(new ArrayList<Object>(Arrays.asList(
					Double.parseDouble(rowElements[0]),
					Integer.parseInt(rowElements[1]))));
		}

    	return array;
    }
}
