package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.PointPlacement;
import com.hyjavacharts.model.highcharts.constants.Stacking;
import com.hyjavacharts.model.highcharts.constants.TickmarkPlacement;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class WindRoseES extends DemoChartBase {
	private static final long serialVersionUID = 5694030594066331122L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN).setPolar(true);
		chartOptions.getTitle().setText("Wind rose for South Shore Met Station, Oregon");
		chartOptions.getSubtitle().setText("Source: or.water.usgs.gov");
		
		chartOptions.getPaneSingle().setSizeAsString("85%");
		chartOptions.getLegend()
			.setAlign(HorizontalAlign.RIGHT)
			.setVerticalAlign(VerticalAlign.TOP)
			.setY(100)
			.setLayout(Layout.VERTICAL);
		
		chartOptions.getXAxisSingle().setTickmarkPlacement(TickmarkPlacement.ON)
			.setCategories(Arrays.asList("N","NNE","NE","ENE","E","ESE","SE","SSE","S","SSW","SW","WSW","W","WNW","NW","NNW"));
		
		chartOptions.getYAxisSingle()
			.setMin(0)
			.setEndOnTick(false)
			.setShowLastLabel(true)
			.setReversedStacks(false)
			.getTitle().setText("Frequency (%)");
		chartOptions.getYAxisSingle().getLabels().getFormatter().setFunctionBody("return this.value + '%';");

		chartOptions.getTooltip().setValueSuffix("%");

		chartOptions.getPlotOptions().getColumn()
			.setStacking(Stacking.NORMAL)
			.setShadowAsBoolean(false)
			.setGroupPadding(0)
			.setPointPlacementAsEnum(PointPlacement.ON);
		
		// data format is csv: direction,< 0.5 m/s, 0.5-2 m/s, 2-4 m/s, 4-6 m/s, 6-8 m/s, 8-10 m/s, > 10 m/s
		//chartOptions.getData().setCsvURL(RestService.getURI() + "/WindRoseCSVData");
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("< 0.5 m/s");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(1.81,0.62,0.82,0.59,0.62,1.22,1.61,2.04,2.66,2.96,2.53,1.97,1.64,1.32,1.58,1.51));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("0.5-2 m/s");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(1.78,1.09,0.82,1.22,2.2,2.01,3.06,3.42,4.74,4.14,4.01,2.66,1.71,2.4,4.28,5));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("2-4 m/s");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(0.16,0,0.07,0.07,0.49,1.55,2.37,1.97,0.43,0.26,1.22,1.97,0.92,0.99,1.28,1.32));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("4-6 m/s");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(0,0,0,0,0,0.3,2.14,0.86,0,0,0.49,0.79,1.45,1.61,0.76,0.13));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("6-8 m/s");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(0,0,0,0,0,0.13,1.74,0.53,0,0,0.13,0.3,0.26,0.33,0.66,0.23));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("8-10 m/s");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(0,0,0,0,0,0,0.39,0.49,0,0,0,0,0.1,0,0.69,0.13));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName(" > 10 m/s");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(0,0,0,0,0,0,0.13,0,0,0,0,0,0,0,0.03,0.07));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}

}
