package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.PointPlacement;
import com.hyjavacharts.model.highcharts.constants.Stacking;
import com.hyjavacharts.model.highcharts.constants.TickmarkPlacement;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class WindRose extends DemoChartBase {
	private static final long serialVersionUID = -4137728141954340883L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN).setPolar(true);
		chartOptions.getTitle().setText("Wind rose for South Shore Met Station, Oregon");
		chartOptions.getSubtitle().setText("Source: or.water.usgs.gov");
		
		chartOptions.getPaneSingle().setSizeAsString("85%");
		chartOptions.getLegend()
			.setAlign(HorizontalAlign.RIGHT)
			.setVerticalAlign(VerticalAlign.TOP)
			.setY(100)
			.setLayout(Layout.VERTICAL);
		
		chartOptions.getXAxisSingle().setTickmarkPlacement(TickmarkPlacement.ON);
		
		chartOptions.getYAxisSingle()
			.setMin(0)
			.setEndOnTick(false)
			.setShowLastLabel(true)
			.setReversedStacks(false)
			.getTitle().setText("Frequency (%)");
		chartOptions.getYAxisSingle().getLabels().getFormatter().setFunctionBody("return this.value + '%';");

		chartOptions.getTooltip().setValueSuffix("%");

		chartOptions.getPlotOptions().getColumn()
			.setStacking(Stacking.NORMAL)
			.setShadowAsBoolean(false)
			.setGroupPadding(0)
			.setPointPlacementAsEnum(PointPlacement.ON);
		
		// data format is csv: direction,< 0.5 m/s, 0.5-2 m/s, 2-4 m/s, 4-6 m/s, 6-8 m/s, 8-10 m/s, > 10 m/s
		chartOptions.getData().setCsvURL(RestService.getURI() + "/WindRoseCSVData");
		
		return highChart;
	}

}
