package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.hyjavacharts.model.highcharts.series.SeriesWindbarb;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.util.DateUtil;

public class WindBarb extends DemoChartBase {
	private static final long serialVersionUID = -2820627514993198946L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Highcharts Wind Barbs");
		chartOptions.getXAxisSingle().setType(AxisType.DATETIME).setOffset(40);
		
		chartOptions.getPlotOptions().getSeries()
			.setPointStart(DateUtil.toMilli(2017, 1, 29))
			.setPointInterval(36e5);
		
		SeriesWindbarb seriesWindbarb = new SeriesWindbarb();
		seriesWindbarb.setType(SeriesType.WINDBARB)
			.setName("Wind")
			.setShowInLegend(false)
			.setColor(chartOptions.getColors().get(1))
			.getTooltip().setValueSuffix(" m/s");
		seriesWindbarb.setDataAsArrayJavaObject(getSeriesData(1));
		chartOptions.getSeries().add(seriesWindbarb);
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setType(SeriesType.AREA)
			.setName("Wind speed")
			.setColor(chartOptions.getColors().get(0))
			.getTooltip().setValueSuffix(" m/s");
		
		ArrayList<Stop> stops = new ArrayList<Stop>();
		stops.add(new Stop(0, chartOptions.getColors().get(0)));
		stops.add(new Stop(1, new Color().setColorValue("Highcharts.color(Highcharts.getOptions().colors[0]).setOpacity(0.25).get()")));

		seriesArea.getFillColor().setStops(stops).getLinearGradient().setX1(0).setX2(0).setY1(0).setY2(1);
		
		seriesArea.getKeys().add("y");
		seriesArea.getKeys().add("rotation");
		seriesArea.setDataAsArrayJavaObject(getSeriesData(2));
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Object> getSeriesData(int series) {
		ArrayList<Object> array = new ArrayList<Object>();
		
    	if (series == 1) {
    		array.add(Arrays.asList(9.8, 177.9));
    		array.add(Arrays.asList(10.1, 177.2));
            array.add(Arrays.asList(11.3, 179.7));
            array.add(Arrays.asList(10.9, 175.5));
            array.add(Arrays.asList(9.3, 159.9));
            array.add(Arrays.asList(8.8, 159.6));
            array.add(Arrays.asList(7.8, 162.6));
            array.add(Arrays.asList(5.6, 186.2));
            array.add(Arrays.asList(6.8, 146.0));
            array.add(Arrays.asList(6.4, 139.9));
            array.add(Arrays.asList(3.1, 180.2));
            array.add(Arrays.asList(4.3, 177.6));
            array.add(Arrays.asList(5.3, 191.8));
            array.add(Arrays.asList(6.3, 173.1));
            array.add(Arrays.asList(7.7, 140.2));
            array.add(Arrays.asList(8.5, 136.1));
            array.add(Arrays.asList(9.4, 142.9));
            array.add(Arrays.asList(10.0, 140.4));
            array.add(Arrays.asList(5.3, 142.1));
            array.add(Arrays.asList(3.8, 141.0));
            array.add(Arrays.asList(3.3, 116.5));
            array.add(Arrays.asList(1.5, 327.5));
            array.add(Arrays.asList(0.1, 1.1));
            array.add(Arrays.asList(1.2, 11.1));
    	}
    	else if (series == 2) {
    		array.add(Arrays.asList(9.8, 177.9));
    		array.add(Arrays.asList(10.1, 177.2));
            array.add(Arrays.asList(11.3, 179.7));
            array.add(Arrays.asList(10.9, 175.5));
            array.add(Arrays.asList(9.3, 159.9));
            array.add(Arrays.asList(8.8, 159.6));
            array.add(Arrays.asList(7.8, 162.6));
            array.add(Arrays.asList(5.6, 186.2));
            array.add(Arrays.asList(6.8, 146.0));
            array.add(Arrays.asList(6.4, 139.9));
            array.add(Arrays.asList(3.1, 180.2));
            array.add(Arrays.asList(4.3, 177.6));
            array.add(Arrays.asList(5.3, 191.8));
            array.add(Arrays.asList(6.3, 173.1));
            array.add(Arrays.asList(7.7, 140.2));
            array.add(Arrays.asList(8.5, 136.1));
            array.add(Arrays.asList(9.4, 142.9));
            array.add(Arrays.asList(10.0, 140.4));
            array.add(Arrays.asList(5.3, 142.1));
            array.add(Arrays.asList(3.8, 141.0));
            array.add(Arrays.asList(3.3, 116.5));
            array.add(Arrays.asList(1.5, 327.5));
            array.add(Arrays.asList(0.1, 1.1));
            array.add(Arrays.asList(1.2, 11.1));
    	}

    	return array;
    }
}
