package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Function;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesWaterfall;
import com.hyjavacharts.model.highcharts.series.serieswaterfall.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class Waterfall extends DemoChartBase {
	private static final long serialVersionUID = -324438006882613276L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.WATERFALL);
		chartOptions.getTitle().setText("Highcharts Waterfall");

		chartOptions.getXAxisSingle().setType(AxisType.CATEGORY);
		chartOptions.getYAxisSingle().getTitle().setText("USD");
		
		chartOptions.getLegend().setEnabled(false);
		chartOptions.getTooltip().setPointFormat("<b>${point.y:,.2f}</b> USD");
		
		SeriesWaterfall seriesWaterfall = new SeriesWaterfall();
		seriesWaterfall.setUpColor(chartOptions.getColors().get(2))
			.setColor(chartOptions.getColors().get(3))
			.setPointPadding(0)
			.getDataLabels().setEnabled(true)
				.setFormatter(new Function("return Highcharts.numberFormat(this.y / 1000, 0, ',') + 'k';"))
				.getStyle().setFontWeight("bold");
		seriesWaterfall.setDataAsArrayObject(getSeriesData(chartOptions));
		chartOptions.getSeries().add(seriesWaterfall);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData(ChartOptions chartOptions) {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Start").setY(120000));
		array.add(new Data().setName("Product Revenue").setY(569000));
		array.add(new Data().setName("Service Revenue").setY(231000));
		array.add(new Data().setName("Positive Balance").setIsIntermediateSum(true).setColor(chartOptions.getColors().get(1)));
		array.add(new Data().setName("Fixed Costs").setY(-342000));
		array.add(new Data().setName("Variable Costs").setY(-233000));
		array.add(new Data().setName("Balance").setIsSum(true).setColor(chartOptions.getColors().get(1)));

    	return array;
    }
	
}
