package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesVenn;
import com.hyjavacharts.model.highcharts.series.seriesvenn.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class VennDiagram extends DemoChartBase {
	private static final long serialVersionUID = 3938734595338846374L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("The Unattainable Triangle");
		
		SeriesVenn seriesVenn = new SeriesVenn();
		seriesVenn.setType(SeriesType.VENN);
		seriesVenn.setName("The Unattainable Triangle");
		seriesVenn.setDataAsArrayObject(Arrays.asList(
				new Data().setValue(2).setSets(Arrays.asList("Good")),
				new Data().setValue(2).setSets(Arrays.asList("Fast")),
				new Data().setValue(2).setSets(Arrays.asList("Cheap")),
				new Data().setValue(1).setSets(Arrays.asList("Good", "Fast")).setName("More expensive"),
				new Data().setValue(1).setSets(Arrays.asList("Good", "Cheap")).setName("Will take time to deliver"),
				new Data().setValue(1).setSets(Arrays.asList("Fast", "Cheap")).setName("Not the best quality"),
				new Data().setValue(1).setSets(Arrays.asList("Fast", "Cheap", "Good")).setName("They're dreaming")
						));
		chartOptions.getSeries().add(seriesVenn);
		
		return highChart;
	}
	
}
