package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesVector;
import com.webonlineapp.hyjavachartsdemo7flow.chartdata.VectorPlotData;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class VectorPlot extends DemoChartBase {
	private static final long serialVersionUID = 8997893772069907779L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.VECTOR);
		chartOptions.getTitle().setText("Highcharts Vector plot");

		chartOptions.getXAxisSingle().setMin(0).setMax(100).setGridLineWidth(1);
		chartOptions.getYAxisSingle().setMin(0).setMax(100);

		SeriesVector seriesVector = new SeriesVector();
		seriesVector.setName("Sample vector field").setColor(chartOptions.getColors().get(1));
		seriesVector.setDataAsArrayJavaObject(new VectorPlotData().getSeriesData());
		chartOptions.getSeries().add(seriesVector);
		
		return highChart;
	}
	
}
