package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesVariwide;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class VariWide extends DemoChartBase {
	private static final long serialVersionUID = 7724613498769010749L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.VARIWIDE);
		chartOptions.getTitle().setText("Labor Costs in Europe, 2016");
		chartOptions.getSubtitle().setText("Source: <a href=\"http://ec.europa.eu/eurostat/web/labour-market/labour-costs/main-tables\">eurostat</a>");

		chartOptions.getXAxisSingle().setType(AxisType.CATEGORY).getTitle().setText("Column widths are proportional to GDP");
		
		chartOptions.getLegend().setEnabled(false);

		SeriesVariwide seriesVariwide = new SeriesVariwide();
		seriesVariwide.setName("Labor Costs")
			.getDataLabels().setEnabled(true)
			.setFormat("€{point.y:.0f}");
		seriesVariwide.getTooltip().setPointFormat("Labor Costs: <b>€ {point.y}/h</b><br>GDP: <b>€ {point.z} million</b><br>");
		seriesVariwide.setColorByPoint(true);
		seriesVariwide.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesVariwide);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Object> getSeriesData() {
		ArrayList<Object> array = new ArrayList<Object>();
		
    	array.add(Arrays.asList("Norway", 50.2, 335504));
    	array.add(Arrays.asList("Denmark", 42, 277339));
    	array.add(Arrays.asList("Belgium", 39.2, 421611));
    	array.add(Arrays.asList("Sweden", 38, 462057));
    	array.add(Arrays.asList("France", 35.6, 2228857));
    	array.add(Arrays.asList("Netherlands", 34.3, 702641));
    	array.add(Arrays.asList("Finland", 33.2, 215615));
    	array.add(Arrays.asList("Germany", 33.0, 3144050));
    	array.add(Arrays.asList("Austria", 32.7, 349344));
    	array.add(Arrays.asList("Ireland", 30.4, 275567));
    	array.add(Arrays.asList("Italy", 27.8, 1672438));
    	array.add(Arrays.asList("United Kingdom", 26.7, 2366911));
    	array.add(Arrays.asList("Spain", 21.3, 1113851));
    	array.add(Arrays.asList("Greece", 14.2, 175887));
    	array.add(Arrays.asList("Portugal", 13.7, 184933));
    	array.add(Arrays.asList("Czech Republic", 10.2, 176564));
    	array.add(Arrays.asList("Poland", 8.6, 424269));
    	array.add(Arrays.asList("Romania", 5.5, 169578));

    	return array;
    }
}
