package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.LayoutAlgorithm;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesTreemap;
import com.hyjavacharts.model.highcharts.series.seriestreemap.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class TreeMapWithLevels extends DemoChartBase {
	private static final long serialVersionUID = -6404838250913732118L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Fruit consumption");
		
		SeriesTreemap seriesTreemap = new SeriesTreemap();
		seriesTreemap.setType(SeriesType.TREEMAP)
			.setLayoutAlgorithm(LayoutAlgorithm.STRIPES)
			.setAlternateStartingDirection(true)
			.getLevelsSingle().setLevel(1)
				.setLayoutAlgorithm(LayoutAlgorithm.SLICEANDDICE)
				.getDataLabels().setEnabled(true).setAlign(HorizontalAlign.LEFT)
								.setVerticalAlign(VerticalAlign.TOP).getStyle().setFontSize("15px").setFontWeight("bold");
		
		seriesTreemap.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesTreemap);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setId("A").setName("Apples").setColor(new Color("#EC2500")));
		array.add(new Data().setId("B").setName("Bananas").setColor(new Color("#ECE100")));
		array.add(new Data().setId("O").setName("Oranges").setColor(new Color("#EC9800")));
		array.add(new Data().setName("Anne").setParent("A").setValue(5));
		array.add(new Data().setName("Rick").setParent("A").setValue(3));
		array.add(new Data().setName("Peter").setParent("A").setValue(4));
		array.add(new Data().setName("Anne").setParent("B").setValue(4));
		array.add(new Data().setName("Rick").setParent("B").setValue(10));
		array.add(new Data().setName("Peter").setParent("B").setValue(1));
		array.add(new Data().setName("Anne").setParent("O").setValue(1));
		array.add(new Data().setName("Rick").setParent("O").setValue(3));
		array.add(new Data().setName("Peter").setParent("O").setValue(3));
		array.add(new Data().setName("Susanne").setParent("Kiwi").setValue(2).setColor(new Color("#9EDE00")));
		
		return array;
    }
	
}
