package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.LayoutAlgorithm;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesTreemap;
import com.hyjavacharts.model.highcharts.series.seriestreemap.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class TreeMapWithColorAxis extends DemoChartBase {
	private static final long serialVersionUID = 6010259981603435995L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Highcharts Treemap");
		
		chartOptions.getColorAxisSingle()
			.setMinColor(new Color("#FFFFFF"))
			.setMaxColor(chartOptions.getColors().get(0));
		
		SeriesTreemap seriesTreemap = new SeriesTreemap();
		seriesTreemap.setType(SeriesType.TREEMAP)
			.setLayoutAlgorithm(LayoutAlgorithm.SQUARIFIED);
		seriesTreemap.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesTreemap);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("A").setValue(6).setColorValue(1));
		array.add(new Data().setName("B").setValue(6).setColorValue(2));
		array.add(new Data().setName("C").setValue(4).setColorValue(3));
		array.add(new Data().setName("D").setValue(3).setColorValue(4));
		array.add(new Data().setName("E").setValue(2).setColorValue(5));
		array.add(new Data().setName("F").setValue(2).setColorValue(6));
		array.add(new Data().setName("G").setValue(1).setColorValue(7));
		
		return array;
    }
}
