package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesTimeline;
import com.hyjavacharts.model.highcharts.series.seriestimeline.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class Timeline extends DemoChartBase {
	private static final long serialVersionUID = -1419356527739633815L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.TIMELINE);
		chartOptions.getTitle().setText("Timeline of Space Exploration");
		chartOptions.getSubtitle().setText("Info source: <a href=\"https://en.wikipedia.org/wiki/Timeline_of_space_exploration\">www.wikipedia.org</a>");
		
		chartOptions.getXAxisSingle().setVisible(false);
		chartOptions.getYAxisSingle().setVisible(false);
		
		chartOptions.setColors(Arrays.asList(
			new Color("#4185F3"), new Color("#427CDD"), new Color("#406AB2"), new Color("#3E5A8E"), new Color("#3B4A68"), new Color("#363C46")));
		
		SeriesTimeline seriesTimeline = new SeriesTimeline();
		seriesTimeline.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesTimeline);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("First dogs").setLabel("1951: First dogs in space").setDescription("22 July 1951 First dogs in space (Dezik and Tsygan)"));
		array.add(new Data().setName("Sputnik 1").setLabel("1957: First artificial satellite").setDescription("4 October 1957 First artificial satellite. First signals from space."));
		array.add(new Data().setName("First human spaceflight").setLabel("1961: First human spaceflight (Yuri Gagarin)").setDescription("First human spaceflight (Yuri Gagarin), and the first human-crewed orbital flight"));
		array.add(new Data().setName("First human on the Moon").setLabel("1969: First human on the Moon").setDescription("First human on the Moon, and first space launch from a celestial body other than the Earth. First sample return from the Moon"));
		array.add(new Data().setName("First space station").setLabel("1971: First space station").setDescription("Salyut 1 was the first space station of any kind, launched into low Earth orbit by the Soviet Union on April 19, 1971."));
		array.add(new Data().setName("Apollo–Soyuz Test Project").setLabel("1975: First multinational manned mission").setDescription("The mission included both joint and separate scientific experiments, and provided useful engineering experience for future joint US–Russian space flights, such as the Shuttle–Mir Program and the International Space Station."));

    	return array;
    }
}
