package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import javax.ws.rs.client.WebTarget;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class TimeSeriesZoomable extends DemoChartBase {
	private static final long serialVersionUID = -1465976684037847603L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getChart().setZoomType(ZoomType.X);
		chartOptions.getTitle().setText("USD to EUR exchange rate over time");
		chartOptions.getSubtitle().setText("Click and drag in the plot area to zoom in");
	
		chartOptions.getXAxis().add(new XAxis().setType(AxisType.DATETIME));
		
		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Exchange rate");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getLegend().setEnabled(false);
		
		ArrayList<Stop> stops = new ArrayList<Stop>();
		stops.add(new Stop(0, new Color().setColorValue("Highcharts.getOptions().colors[0]")));
		stops.add(new Stop(1, new Color().setColorValue("Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0).get('rgba')")));
		chartOptions.getPlotOptions().getArea().getFillColor().setStops(stops).getLinearGradient().setX1(0).setX2(0).setY1(0).setY2(1);
		
		chartOptions.getPlotOptions().getArea().getMarker().setRadius(2);
		chartOptions.getPlotOptions().getArea().setLineWidth(1);
		chartOptions.getPlotOptions().getArea().getStates().getHover().setLineWidth(1);
		chartOptions.getPlotOptions().getArea().setThresholdAsNumber(null);
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setType(SeriesType.AREA).setName("USD to EUR");
		seriesArea.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Object> getSeriesData() {
		ArrayList<Object> array = new ArrayList<Object>();
    	
    	// REST service returns CSV time rate data in format date,rate
		WebTarget webTarget = new RestService().getWebTarget();
		String timeData = webTarget.path("TimeSeriesZoomableCSVData").request().get(String.class);

		String[] dataRows = timeData.split("\n");
		
		for(int i = 1; i < dataRows.length; i++) {
			String[] rowElements = dataRows[i].split(",");

			array.add(new ArrayList<Object>(Arrays.asList(Long.parseLong(rowElements[0]), Double.parseDouble(rowElements[1]))));
		}

    	return array;
    }
	
}
