package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDPie extends DemoChartBase {
	private static final long serialVersionUID = 8921827979388907821L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getChart().setType(ChartType.PIE)
			.getOptions3d()
				.setEnabled(true)
				.setAlpha(45)
				.setBeta(0);
		
		chartOptions.getTitle().setText("Browser market shares at a specific website, 2014");
		chartOptions.getTooltip().setPointFormat("{series.name}: <b>{point.percentage:.1f}%</b>");
		
		chartOptions.getPlotOptions().getPie()
			.setAllowPointSelect(true)
			.setCursor(Cursor.POINTER)
			.setDepth(35)
			.getDataLabels()
				.setEnabled(true)
				.setFormat("{point.name}");
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setType(SeriesType.PIE).setName("Browser share");
		seriesPie.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPie);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Firefox").setY(45.0));
		array.add(new Data().setName("IE").setY(26.8));
		array.add(new Data().setName("Chrome").setY(12.8).setSliced(true).setSelected(true));
		array.add(new Data().setName("Safari").setY(8.5));
		array.add(new Data().setName("Opera").setY(6.2));
		array.add(new Data().setName("Others").setY(0.7));
		
		return array;
    }
	
}
