package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesFunnel3d;
import com.hyjavacharts.model.highcharts.series.seriesfunnel3d.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDFunnelChart extends DemoChartBase {
	private static final long serialVersionUID = -995115629897707603L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart()
			.setType(ChartType.FUNNEL3D)
			.getOptions3d().setEnabled(true).setAlpha(10).setDepth(50).setViewDistance(50);
		
		chartOptions.getTitle().setText("Highcharts Funnel3D Chart");
		
		chartOptions.getPlotOptions()
			.getFunnel3d()
				.setNeckWidthAsString("30%")
				.setNeckHeightAsString("25%")
				.setWidthAsString("80%")
				.setHeightAsString("80%")
				.getDataLabels()
					.setEnabled(true)
					.setFormat("<b>{point.name}</b> ({point.y:,.0f})")
					.setColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'"))
					.setAllowOverlap(true)
					.setY(10);
		
		SeriesFunnel3d seriesFunnel = new SeriesFunnel3d();
		seriesFunnel.getAccessibility().setEnabled(false);
		seriesFunnel.setName("Unique users");
		seriesFunnel.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesFunnel);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Website visits").setY(15654));
		array.add(new Data().setName("Downloads").setY(4064));
		array.add(new Data().setName("Requested price list").setY(1987));
		array.add(new Data().setName("Invoice sent").setY(976));
		array.add(new Data().setName("Finalized").setY(846));

    	return array;
    }
	
}
