package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDColumn extends DemoChartBase {
	private static final long serialVersionUID = -5476371176268077264L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("3d Chart demo");
		
		chartOptions.getChart().getOptions3d()
			.setEnabled(true)
			.setAlpha(15)
			.setBeta(15)
			.setDepth(50)
			.setViewDistance(25);
		
		chartOptions.getPlotOptions().getColumn().setDepth(25);

		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setDataAsArrayNumber(Arrays.asList(29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 
							  							216.4, 194.1, 95.6, 54.4));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}

}
