package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Stacking;
import com.hyjavacharts.model.highcharts.series.SeriesBar;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class StackedBar extends DemoChartBase {
	private static final long serialVersionUID = -8988673715423847682L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.BAR);
		chartOptions.getTitle().setText("Stacked bar chart");

		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Apples", "Oranges", "Pears", "Grapes", "Bananas"));
		chartOptions.getXAxis().add(xAxi);
		
		YAxis yAxi = new YAxis();
		yAxi.setMin(0).getTitle().setText("Total fruit consumption");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getLegend().setReversed(true);
		chartOptions.getPlotOptions().getBar().setStacking(Stacking.NORMAL);
		
		SeriesBar seriesBar = new SeriesBar();
		seriesBar.setName("John");
		seriesBar.setDataAsArrayNumber(Arrays.asList(5, 3, 4, 7, 2));
		chartOptions.getSeries().add(seriesBar);
		
		seriesBar = new SeriesBar();
		seriesBar.setName("Jane");
		seriesBar.setDataAsArrayNumber(Arrays.asList(2, 2, 3, 2, 1));
		chartOptions.getSeries().add(seriesBar);
		
		seriesBar = new SeriesBar();
		seriesBar.setName("Joe");
		seriesBar.setDataAsArrayNumber(Arrays.asList(3, 4, 4, 2, 5));
		chartOptions.getSeries().add(seriesBar);
		
		return highChart;
	}

}
