package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Stacking;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class StackedAndGroupedColumn extends DemoChartBase {
	private static final long serialVersionUID = 3692980026061377498L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("Total fruit consumtion, grouped by gender");

		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Apples", "Oranges", "Pears", "Grapes", "Bananas"));
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.setAllowDecimals(false)
			.setMin(0)
			.getTitle().setText("Number of fruits");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getTooltip()
			.getFormatter()
				.setFunctionBody("return '<b>' + this.x + '</b><br/>' + this.series.name + ': ' + this.y + '<br/>' + 'Total: ' + this.point.stackTotal;");
		
		chartOptions.getPlotOptions().getColumn()
			.setStacking(Stacking.NORMAL);
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("John").setStackAsString("male");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(5, 3, 4, 7, 2));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Joe").setStackAsString("male");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(3, 4, 4, 2, 5));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Jane").setStackAsString("female");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(2, 5, 6, 2, 1));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Janet").setStackAsString("female");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(3, 0, 4, 4, 3));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}
	
}
