package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.LabelsOverflow;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.hyjavacharts.model.highcharts.yaxis.PlotBands;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.util.DateUtil;

public class SplineWithPlotBands extends DemoChartBase {
	private static final long serialVersionUID = -6340628677257733776L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.SPLINE)
			.getScrollablePlotArea().setMinWidth(600).setScrollPositionX(1);
		
		chartOptions.getTitle().setText("Wind speed during two days");
		chartOptions.getSubtitle().setText("13th & 14th of February, 2018 at two locations in Vik i Sogn, Norway");

		XAxis xAxi = new XAxis();
		xAxi.setType(AxisType.DATETIME).getLabels().setOverflow(LabelsOverflow.JUSTIFY);
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Wind speed (m/s)");
		yAxi.setMinorGridLineWidth(0).setGridLineWidth(0).setAlternateGridColor(null);
		
		PlotBands pb = new PlotBands();
		pb.setFrom(0.3).setTo(1.5).setColor(new Color().setRGBA(68, 170, 213, 0.1)).getLabel().setText("Light air").getStyle().setColor(new Color("#606060"));
		yAxi.getPlotBands().add(pb);

		pb = new PlotBands();
		pb.setFrom(1.5).setTo(3.3).setColor(new Color().setRGBA(0, 0, 0, 0)).getLabel().setText("Light breeze").getStyle().setColor(new Color("#606060"));
		yAxi.getPlotBands().add(pb);
		
		pb = new PlotBands();
		pb.setFrom(3.3).setTo(5.5).setColor(new Color().setRGBA(68, 170, 213, 0.1)).getLabel().setText("Gentle breeze").getStyle().setColor(new Color("#606060"));
		yAxi.getPlotBands().add(pb);
		
		pb = new PlotBands();
		pb.setFrom(5.5).setTo(8).setColor(new Color().setRGBA(0, 0, 0, 0)).getLabel().setText("Moderate breeze").getStyle().setColor(new Color("#606060"));
		yAxi.getPlotBands().add(pb);

		pb = new PlotBands();
		pb.setFrom(8).setTo(11).setColor(new Color().setRGBA(68, 170, 213, 0.1)).getLabel().setText("Fresh breeze").getStyle().setColor(new Color("#606060"));
		yAxi.getPlotBands().add(pb);
		
		pb = new PlotBands();
		pb.setFrom(11).setTo(14).setColor(new Color().setRGBA(0, 0, 0, 0)).getLabel().setText("Strong breeze").getStyle().setColor(new Color("#606060"));
		yAxi.getPlotBands().add(pb);
		
		pb = new PlotBands();
		pb.setFrom(14).setTo(15).setColor(new Color().setRGBA(68, 170, 213, 0.1)).getLabel().setText("High wind").getStyle().setColor(new Color("#606060"));
		yAxi.getPlotBands().add(pb);
		
		chartOptions.getYAxis().add(yAxi);

		chartOptions.getTooltip().setValueSuffix(" m/s");
		
		chartOptions.getPlotOptions().getSpline().setLineWidth(4).getStates().getHover().setLineWidth(5);
		chartOptions.getPlotOptions().getSpline().setPointInterval(3600000)
			.setPointStart(DateUtil.toMilli(2018, 2, 13))
			.getMarker().setEnabled(false);

		chartOptions.getNavigation().getMenuItemStyle().setFontSize("10px");	
		
		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setName("Hestavollane");
		seriesSpline.setDataAsArrayNumber(Arrays.asList(
				3.7, 3.3, 3.9, 5.1, 3.5, 3.8, 4.0, 5.0, 6.1, 3.7, 3.3, 6.4,
	            6.9, 6.0, 6.8, 4.4, 4.0, 3.8, 5.0, 4.9, 9.2, 9.6, 9.5, 6.3,
	            9.5, 10.8, 14.0, 11.5, 10.0, 10.2, 10.3, 9.4, 8.9, 10.6, 10.5, 11.1,
	            10.4, 10.7, 11.3, 10.2, 9.6, 10.2, 11.1, 10.8, 13.0, 12.5, 12.5, 11.3,
	            10.1));
		chartOptions.getSeries().add(seriesSpline);
		
		seriesSpline = new SeriesSpline();
		seriesSpline.setName("Vik");
		seriesSpline.setDataAsArrayNumber(Arrays.asList(
				0.2, 0.1, 0.1, 0.1, 0.3, 0.2, 0.3, 0.1, 0.7, 0.3, 0.2, 0.2,
	            0.3, 0.1, 0.3, 0.4, 0.3, 0.2, 0.3, 0.2, 0.4, 0.0, 0.9, 0.3,
	            0.7, 1.1, 1.8, 1.2, 1.4, 1.2, 0.9, 0.8, 0.9, 0.2, 0.4, 1.2,
	            0.3, 2.3, 1.0, 0.7, 1.0, 0.8, 2.0, 1.2, 1.4, 3.7, 2.1, 2.0,
	            1.5));
		chartOptions.getSeries().add(seriesSpline);
		
		return highChart;
	}
	
}
