package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.GridLineInterpolation;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.PointPlacement;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.constants.TickmarkPlacement;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesLine;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class SpiderWeb extends DemoChartBase {
	private static final long serialVersionUID = -9025495014987843977L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.LINE).setPolar(true);
		chartOptions.getTitle().setText("Budget vs spending").setX(-80);
		
		chartOptions.getPaneSingle().setSizeAsString("80%");
		
		chartOptions.getXAxisSingle()
			.setCategories(Arrays.asList(
				"Sales", "Marketing", "Development", "Customer Support", "Information Technology", "Administration"))
			.setTickmarkPlacement(TickmarkPlacement.ON)
			.setLineWidth(0);

		chartOptions.getYAxisSingle()
			.setGridLineInterpolation(GridLineInterpolation.POLYGON)
			.setLineWidth(0)
			.setMin(0);
		
		chartOptions.getTooltip()
			.setShared(true)
			.setPointFormat("<span style=\"color:{series.color}\">{series.name}: <b>${point.y:,.0f}</b><br/>");

		chartOptions.getLegend()
			.setAlign(HorizontalAlign.RIGHT)
			.setVerticalAlign(VerticalAlign.TOP)
			.setY(70)
			.setLayout(Layout.VERTICAL);
		
		SeriesLine seriesLine = new SeriesLine();
		seriesLine.setType(SeriesType.LINE)
			.setName("Allocated Budget")
			.setPointPlacementAsEnum(PointPlacement.ON);
		seriesLine.setDataAsArrayNumber(Arrays.asList(43000, 19000, 60000, 35000, 17000, 10000));
		chartOptions.getSeries().add(seriesLine);
		
		seriesLine = new SeriesLine();
		seriesLine.setType(SeriesType.LINE)
			.setName("Actual Spending")
			.setPointPlacementAsEnum(PointPlacement.ON);
		seriesLine.setDataAsArrayNumber(Arrays.asList(50000, 39000, 42000, 31000, 26000, 14000));
		chartOptions.getSeries().add(seriesLine);
		
		return highChart;
	}

}
