package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesLine;
import com.hyjavacharts.model.highcharts.series.SeriesScatter;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ScatterWithRegressionLine extends DemoChartBase {
	private static final long serialVersionUID = 3207408029127726119L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Scatter plot with regression line");

		XAxis xAxi = new XAxis();
		xAxi.setMin(-0.5).setMax(5.5);
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.setMin(0);
		chartOptions.getYAxis().add(yAxi);
		
		SeriesLine seriesLine = new SeriesLine();
		seriesLine.setType(SeriesType.LINE)
			.setName("Regression Line")
			.setEnableMouseTracking(false)
			.getMarker().setEnabled(false);
		seriesLine.getStates().getHover().setLineWidth(0);
		seriesLine.setDataAsArrayJavaObject(getSeriesData(1));
		chartOptions.getSeries().add(seriesLine);

		SeriesScatter seriesScatter = new SeriesScatter();
		seriesScatter.setType(SeriesType.SCATTER)
			.setName("Observations")
			.getMarker().setRadius(4);
		seriesScatter.setDataAsArrayJavaObject(getSeriesData(2));
		chartOptions.getSeries().add(seriesScatter);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Object> getSeriesData(int series) {
		ArrayList<Object> array = new ArrayList<Object>();
		
    	if (series == 1) {
    		array.add(Arrays.asList(0, 1.11));
    		array.add(Arrays.asList(5, 4.51));
    	}
    	else if (series == 2) {
    		array = new ArrayList<Object>(Arrays.asList(1, 1.5, 2.8, 3.5, 3.9, 4.2));
    	}

    	return array;
    }
}
