package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesScatter;
import com.webonlineapp.hyjavachartsdemo7flow.chartdata.ScatterPlotData;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ScatterPlot extends DemoChartBase {
	private static final long serialVersionUID = -7625816907571486021L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();

		chartOptions.getChart().setType(ChartType.SCATTER)
			.setZoomType(ZoomType.XY);
		
		chartOptions.getTitle().setText("Height Versus Weight of 507 Individuals by Gender");
		chartOptions.getSubtitle().setText("Source: Heinz  2003");

		chartOptions.getXAxisSingle()
			.setStartOnTick(true)
			.setEndOnTick(true)
			.setShowLastLabel(true);
			
		chartOptions.getYAxisSingle().getTitle().setText("Weight (kg)");
		
		chartOptions.getLegend()
			.setLayout(Layout.VERTICAL)
			.setAlign(HorizontalAlign.LEFT)
			.setVerticalAlign(VerticalAlign.TOP)
			.setX(100)
			.setY(70)
			.setFloating(true)
			.setBorderWidth(1)
			.getBackgroundColor().setColorValue("(Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'");

		chartOptions.getPlotOptions().getScatter()
			.getMarker()
				.setRadius(5)
				.getStates()
					.getHover()
						.setEnabled(true)
						.setLineColor(new Color().setRGB(100, 100, 100));
		chartOptions.getPlotOptions().getScatter()
			.getStates()
				.getHover()
					.getMarker()
						.setEnabled(false);
		chartOptions.getPlotOptions().getScatter()
			.getTooltip()
				.setHeaderFormat("<b>{series.name}</b><br>")
				.setPointFormat("{point.x} cm, {point.y} kg");
		
		ScatterPlotData seriesData = new ScatterPlotData();
		
		SeriesScatter seriesScatter = new SeriesScatter();
		seriesScatter.setName("Female").setColor(new Color().setRGBA(223, 83, 83, .5));
		seriesScatter.setDataAsArrayJavaObject(seriesData.getSeriesData(1));
		chartOptions.getSeries().add(seriesScatter);
		
		seriesScatter = new SeriesScatter();
		seriesScatter.setName("Male").setColor(new Color().setRGBA(119, 152, 191, .5));
		seriesScatter.setDataAsArrayJavaObject(seriesData.getSeriesData(2));
		chartOptions.getSeries().add(seriesScatter);
		
		return highChart;
	}
	
}
