package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesPyramid;
import com.hyjavacharts.model.highcharts.series.seriespyramid.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PyramidChart extends DemoChartBase {
	private static final long serialVersionUID = 4885769715764305183L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.PYRAMID);
		chartOptions.getTitle().setText("Sales pyramid").setX(-50);

		chartOptions.getPlotOptions()
			.getPyramid()
				.setCenterAsArrayString(Arrays.asList("40%", "50%"))
				.setWidthAsString("80%")
				.getDataLabels()
					.setEnabled(true)
					.setFormat("<b>{point.name}</b> ({point.y:,.0f})")
					.setColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'"))
					.setSoftConnector(true);
		
		chartOptions.getLegend().setEnabled(false);
		
		SeriesPyramid seriesPyramid = new SeriesPyramid();
		seriesPyramid.setName("Unique users");
		seriesPyramid.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPyramid);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Website visits").setY(15654));
		array.add(new Data().setName("Downloads").setY(4064));
		array.add(new Data().setName("Requested price list").setY(1987));
		array.add(new Data().setName("Invoice sent").setY(976));
		array.add(new Data().setName("Finalized").setY(846));

    	return array;
    }
}
