package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.List;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PieWithMonochromeFill extends DemoChartBase {
	private static final long serialVersionUID = -5238275095665000698L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getChart().setType(ChartType.PIE)
			.setPlotShadowAsBoolean(false);
		chartOptions.getTitle().setText("Browser market shares at a specific website, 2014");
		chartOptions.getTooltip().setPointFormat("{series.name}: <b>{point.percentage:.1f}%</b>");
		
		chartOptions.getPlotOptions()
			.getPie()
				.setAllowPointSelect(true)
				.setCursor(Cursor.POINTER)
				.getDataLabels()
					.setEnabled(true)
					.setFormat("<b>{point.name}</b>: {point.percentage:.1f} %")
					.setDistance(-50)
					.getFilter().setProperty("percentage").setOperator(">").setValue(4);
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setName("Brands");
		seriesPie.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPie);
		
		// Create new colors list
		String base = chartOptions.getColors().get(0).getColor();
		List<Color> newColors = new ArrayList<Color>();
		
		for (int i = 0; i < 10; i += 1) {
			double b = (new Double(i) - 3.0) / 7.0;
			newColors.add(new Color(base).brighten(b));
		}
		
		chartOptions.setColors(newColors);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Chrome").setY(61.41));
		array.add(new Data().setName("Internet Explorer").setY(11.84));
		array.add(new Data().setName("Firefox").setY(10.85));
		array.add(new Data().setName("Edge").setY(4.67));
		array.add(new Data().setName("Safari").setY(4.18));
		array.add(new Data().setName("Other").setY(7.05));
		
		return array;
    }
}
