package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PieWithLegend extends DemoChartBase {
	private static final long serialVersionUID = -7794959831733130190L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.PIE)
			.setPlotBorderWidth(null)
			.setPlotShadowAsBoolean(false);
		chartOptions.getTitle().setText("Browser market shares in January, 2018");
		chartOptions.getTooltip().setPointFormat("{series.name}: <b>{point.percentage:.1f}%</b>");
		
		chartOptions.getPlotOptions()
			.getPie()
				.setAllowPointSelect(true)
				.setCursor(Cursor.POINTER)
				.setShowInLegend(true)
				.getDataLabels().setEnabled(false);
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setName("Brands").setColorByPoint(true);
		seriesPie.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPie);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Chrome").setY(61.41).setSliced(true).setSelected(true));
		array.add(new Data().setName("Internet Explorer").setY(11.84));
		array.add(new Data().setName("Firefox").setY(10.85));
		array.add(new Data().setName("Edge").setY(4.67));
		array.add(new Data().setName("Safari").setY(4.18));
		array.add(new Data().setName("Other").setY(7.05));

		return array;
	}
}
