package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Stacking;
import com.hyjavacharts.model.highcharts.constants.TickmarkPlacement;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PercentageArea extends DemoChartBase {
	private static final long serialVersionUID = -2141317458503791577L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.AREA);
		chartOptions.getTitle().setText("Historic and Estimated Worldwide Population Growth by Region");
		
		chartOptions.getSubtitle().setText("Source: Wikipedia.org");
		
		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("1750", "1800", "1850", "1900", "1950", "1999", "2050"))
			.setTickmarkPlacement(TickmarkPlacement.ON)
			.getTitle().setText(null);
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Percent");
		chartOptions.getYAxis().add(yAxi);

		chartOptions.getTooltip()
			.setPointFormat("<span style=\"color:{series.color}\">{series.name}</span>: <b>{point.percentage:.1f}%</b> ({point.y:,.0f} millions)<br/>")
			.setSplit(true);

		chartOptions.getPlotOptions().getArea()
			.setStacking(Stacking.PERCENT)
			.setLineColor(new Color("#ffffff"))
			.setLineWidth(1)
			.getMarker()
				.setLineWidth(1)
				.setLineColor(new Color("#ffffff"));
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setName("Asia");
		seriesArea.setDataAsArrayNumber(Arrays.asList(502, 635, 809, 947, 1402, 3634, 5268));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("Africa");
		seriesArea.setDataAsArrayNumber(Arrays.asList(106, 107, 111, 133, 221, 767, 1766));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("Europe");
		seriesArea.setDataAsArrayNumber(Arrays.asList(163, 203, 276, 408, 547, 729, 628));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("America");
		seriesArea.setDataAsArrayNumber(Arrays.asList(18, 31, 54, 156, 339, 818, 1201));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("Oceania");
		seriesArea.setDataAsArrayNumber(Arrays.asList(2, 2, 2, 6, 13, 30, 46));
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}
	
}
