package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.PatternOptions;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PatternFillPieChart extends DemoChartBase {
	private static final long serialVersionUID = -6280513210892057774L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getTitle().setText("Pattern Fill Pie Demo");
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setType(SeriesType.PIE);
		seriesPie.setBorderColor(chartOptions.getColors().get(0));
		seriesPie.getDataLabels().setConnectorColor(chartOptions.getColors().get(0));
		seriesPie.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPie);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();

		array.add(new Data().setName("default-pattern-0").setY(1).setColor(new Color("url(#highcharts-default-pattern-0)")));
		array.add(new Data().setName("default-pattern-1").setY(1).setColor(new Color("url(#highcharts-default-pattern-1)")));
		array.add(new Data().setName("default-pattern-2").setY(1).setColor(new Color("url(#highcharts-default-pattern-2)")));
		array.add(new Data().setName("default-pattern-3").setY(1).setColor(new Color("url(#highcharts-default-pattern-3)")));
		array.add(new Data().setName("default-pattern-4").setY(1).setColor(new Color("url(#highcharts-default-pattern-4)")));
		array.add(new Data().setName("default-pattern-5").setY(1).setColor(new Color("url(#highcharts-default-pattern-5)")));
		array.add(new Data().setName("default-pattern-6").setY(1).setColor(new Color("url(#highcharts-default-pattern-6)")));
		array.add(new Data().setName("default-pattern-7").setY(1).setColor(new Color("url(#highcharts-default-pattern-7)")));
		array.add(new Data().setName("default-pattern-8").setY(1).setColor(new Color("url(#highcharts-default-pattern-8)")));
		array.add(new Data().setName("default-pattern-9").setY(1).setColor(new Color("url(#highcharts-default-pattern-9)")));
		array.add(new Data().setName("custom pattern").setY(1).setColor(new Color(
				new PatternOptions().setImage("https://www.hyjavacharts.com/content/images/US_one_dollar_bill.jpg").setAspectRatio(9 / 4))));
		
		return array;
	}
}
