package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import javax.ws.rs.client.WebTarget;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class ParallelCoordinates extends DemoChartBase {
	private static final long serialVersionUID = 2676318938232064486L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.SPLINE)
			.setParallelCoordinates(true)
			.getParallelAxes().setLineWidth(2);
		
		chartOptions.getTitle().setText("Marathon set");

		chartOptions.getPlotOptions().getSeries()
			.setAnimationAsBoolean(false)
			.getMarker().setEnabled(false).getStates().getHover().setEnabled(false);
		chartOptions.getPlotOptions().getSpline().getStates().getHover().getHalo().setSize(0);
		chartOptions.getPlotOptions().getSpline().getEvents().getMouseOver().setFunctionBody("this.group.toFront();");
		
		chartOptions.getTooltip()
			.setPointFormat("<span style='color:{point.color}'>\u25CF</span>{series.name}: <b>{point.formattedValue}</b><br/>");

		chartOptions.getXAxisSingle().setOffset(10)
			.setCategories(new ArrayList<String>(Arrays.asList(
					"Training date",
			         "Miles for training run",
			         "Training time",
			         "Shoe brand",
			         "Running pace per mile",
			         "Short or long",
			         "After 2004")));

		YAxis yAxis = new YAxis();
		yAxis.setType(AxisType.DATETIME).setTooltipValueFormat("{value:%Y-%m-%d}");
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.setMin(0).setTooltipValueFormat("{value} mile(s)");
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.setType(AxisType.DATETIME).setMin(0).getLabels().setFormat("{value:%H:%M}");
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.setCategories(Arrays.asList(
				"Other",
		        "Adidas",
		        "Mizuno",
		        "Asics",
		        "Brooks",
		        "New Balance",
		        "Izumi"));
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.setType(AxisType.DATETIME);
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.setCategories(Arrays.asList("&gt; 5miles", "&lt; 5miles"));
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.setCategories(Arrays.asList("Before", "After"));
		chartOptions.getYAxis().add(yAxis);
		
		chartOptions.setColors(Arrays.asList(new Color().setColorValue("'rgba(11, 200, 200, 0.1)'")));

		setSeriesData(chartOptions);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private void setSeriesData(ChartOptions chartOptions) {
		// REST service returns CSV data in format "Training date","Miles for training run","Training time","Shoe brand","Running pace per mile","Short or long","After 2004"
		WebTarget webTarget = new RestService().getWebTarget();
		String heatMapData = webTarget.path("ParallelCoordinatesCSVData").request().get(String.class);

		String[] dataRows = heatMapData.split("\n");
		
		for(int i = 1; i < dataRows.length; i++) {
			String[] rowElements = dataRows[i].split(",");
			
			SeriesSpline seriesSpline = new SeriesSpline();
			seriesSpline.setName("Runner " + i)
				.setShadowAsBoolean(false)
				.setDataAsArrayNumber(new ArrayList<Number>(Arrays.asList(
						Long.parseLong(rowElements[0]),
						Double.parseDouble(rowElements[1]),
						Double.parseDouble(rowElements[2]),
						Integer.parseInt(rowElements[3]),
						Long.parseLong(rowElements[4]),
						Integer.parseInt(rowElements[5]),
						Integer.parseInt(rowElements[6])
						)));
			
			chartOptions.getSeries().add(seriesSpline);
		}
    }

}
