package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.ColorAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesPackedbubble;
import com.webonlineapp.hyjavachartsdemo7flow.chartdata.PackedBubbleChartData;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PackedBubbleWithColorAxis extends DemoChartBase {
	private static final long serialVersionUID = -691133209368549061L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.PACKEDBUBBLE);
		chartOptions.getTitle().setText("Carbon emissions around the world (2014)");
		
		chartOptions.getColorAxis().add(new ColorAxis().setLayout("horizontal").setMinColor(new Color("#7cb5ec")));
		chartOptions.getColorAxis().add(new ColorAxis().setLayout("horizontal").setMinColor(new Color("#434348")));
		chartOptions.getColorAxis().add(new ColorAxis().setLayout("horizontal").setMinColor(new Color("#90ed7d")));
		chartOptions.getColorAxis().add(new ColorAxis().setLayout("horizontal").setMinColor(new Color("#f7a35c")));
		chartOptions.getColorAxis().add(new ColorAxis().setLayout("horizontal").setMinColor(new Color("#8085e9")));
		chartOptions.getColorAxis().add(new ColorAxis().setLayout("horizontal").setMinColor(new Color("#f15c80")));
		
		chartOptions.getLegend()
			.setLayout(Layout.VERTICAL)
			.setVerticalAlign(VerticalAlign.MIDDLE)
			.setAlign(HorizontalAlign.RIGHT)
			.setPadding(30);

		chartOptions.getTooltip().setUseHTML(true).setPointFormat("<b>{point.name}:</b> {point.value}m CO<sub>2</sub>");

		chartOptions.getPlotOptions().getPackedbubble()
			.setColorKey("value")
			.setMinSizeAsString("30%")
			.setMaxSizeAsString("120%")
			.setZMin(0)
			.setZMax(1000)
			.getLayoutAlgorithm()
				.setSplitSeries(false)
				.setGravitationalConstant(0.02);
	
		chartOptions.getPlotOptions().getPackedbubble().getDataLabels()
			.setEnabled(true).setFormat("{point.name}").getFilter().setProperty("y").setOperator(">").setValue(250);
		chartOptions.getPlotOptions().getPackedbubble().getDataLabels()
			.getStyle().setColor(new Color("black")).setTextOutline("none").setFontWeight("normal");
		
		PackedBubbleChartData seriesData = new PackedBubbleChartData();
	
		SeriesPackedbubble seriesPackedbubble = new SeriesPackedbubble();
		seriesPackedbubble.setName("Europe");
		seriesPackedbubble.setDataAsArrayObject(seriesData.getSeriesData(1));
		chartOptions.getSeries().add(seriesPackedbubble);
		
		seriesPackedbubble = new SeriesPackedbubble();
		seriesPackedbubble.setName("Africa").setColorAxisAsNumber(1);
		seriesPackedbubble.setDataAsArrayObject(seriesData.getSeriesData(2));
		chartOptions.getSeries().add(seriesPackedbubble);
		
		seriesPackedbubble = new SeriesPackedbubble();
		seriesPackedbubble.setName("Oceania").setColorAxisAsNumber(2);
		seriesPackedbubble.setDataAsArrayObject(seriesData.getSeriesData(3));
		chartOptions.getSeries().add(seriesPackedbubble);
		
		seriesPackedbubble = new SeriesPackedbubble();
		seriesPackedbubble.setName("NorthAmerica").setColorAxisAsNumber(3);
		seriesPackedbubble.setDataAsArrayObject(seriesData.getSeriesData(4));
		chartOptions.getSeries().add(seriesPackedbubble);
		
		seriesPackedbubble = new SeriesPackedbubble();
		seriesPackedbubble.setName("SouthAmerica").setColorAxisAsNumber(4);
		seriesPackedbubble.setDataAsArrayObject(seriesData.getSeriesData(5));
		chartOptions.getSeries().add(seriesPackedbubble);
		
		seriesPackedbubble = new SeriesPackedbubble();
		seriesPackedbubble.setName("Asia").setColorAxisAsNumber(5);
		seriesPackedbubble.setDataAsArrayObject(seriesData.getSeriesData(6));
		chartOptions.getSeries().add(seriesPackedbubble);

		return highChart;
	}
	
}
