package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.DashStyle;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class MultipleAxis extends DemoChartBase {
	private static final long serialVersionUID = 3675107323440054918L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setZoomType(ZoomType.XY);
		chartOptions.getTitle().setText("Average Monthly Weather Data for Tokyo");
		chartOptions.getSubtitle().setText("Source: WorldClimate.com");

		chartOptions.getXAxisSingle()
			.setCategories(Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"))
			.setCrosshairAsBoolean(true);
		
		YAxis yAxi = new YAxis();
		yAxi.getLabels().setFormat("{value}°C")
			.getStyle().setColor(chartOptions.getColors().get(2));
		
		yAxi.setOpposite(true)
			.getTitle().setText("Temperature")
				.getStyle().setColor(chartOptions.getColors().get(2));
		chartOptions.getYAxis().add(yAxi);
		
		yAxi = new YAxis();
		yAxi.setGridLineWidth(0)
			.getLabels().setFormat("{value} mm")
			.getStyle().setColor(chartOptions.getColors().get(0));
		yAxi.getTitle().setText("Rainfall")
			.getStyle().setColor(chartOptions.getColors().get(0));
		chartOptions.getYAxis().add(yAxi);
		
		yAxi = new YAxis();
		yAxi.setGridLineWidth(0)
			.setOpposite(true)
			.getLabels().setFormat("{value} mb")
			.getStyle().setColor(chartOptions.getColors().get(1));
		yAxi.getTitle().setText("Sea-Level Pressure")
			.getStyle().setColor(chartOptions.getColors().get(1));
		chartOptions.getYAxis().add(yAxi);

		chartOptions.getTooltip().setShared(true);
		
		chartOptions.getLegend().setLayout(Layout.VERTICAL).setAlign(HorizontalAlign.LEFT)
			.setVerticalAlign(VerticalAlign.TOP).setX(80).setY(55).setFloating(true)
			.getBackgroundColor().setColorValue("(Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'");
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setType(SeriesType.COLUMN)
			.setName("Rainfall")
			.setYAxisAsNumber(1)
			.getTooltip().setValueSuffix(" mm");
		seriesColumn.setDataAsArrayNumber(
			Arrays.asList(49.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4));
		chartOptions.getSeries().add(seriesColumn);
		
		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setType(SeriesType.SPLINE)
			.setName("Sea-Level Pressure")
			.setYAxisAsNumber(2)
			.setDashStyle(DashStyle.SHORTDOT)
			.getTooltip().setValueSuffix(" mb");
		seriesSpline.getMarker().setEnabled(false);
		seriesSpline.setDataAsArrayNumber(
			Arrays.asList(1016, 1016, 1015.9, 1015.5, 1012.3, 1009.5, 1009.6, 1010.2, 1013.1, 1016.9, 1018.2, 1016.7));
		chartOptions.getSeries().add(seriesSpline);
		
		seriesSpline = new SeriesSpline();
		seriesSpline.setType(SeriesType.SPLINE)
			.setName("Temperature")
			.getTooltip().setValueSuffix(" °C");;
		seriesSpline.setDataAsArrayNumber(
			Arrays.asList(7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6));
		chartOptions.getSeries().add(seriesSpline);
		
		return highChart;
	}
	
}
