package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class LiveData extends DemoChartBase {
	private static final long serialVersionUID = -6389563520463842146L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.SPLINE);
		chartOptions.getTitle().setText("Live Data (CSV)");
		chartOptions.getSubtitle().setText("Data input from a remote CSV file");

		chartOptions.getData().setCsvURL(RestService.getURI() + "/LiveDataCSVData")
			.setEnablePolling(true);
		
		return highChart;
	}

}
