package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesLine;
import com.hyjavacharts.model.highcharts.series.seriesline.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class LinePoints extends DemoChartBase {
	private static final long serialVersionUID = -3633954510824049807L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getTitle().setText("Daily sessions at www.highcharts.com");
		chartOptions.getSubtitle().setText("Source: Google Analytics");

		//chartOptions.getChart().getScrollablePlotArea().setMinWidth(700);
		
		XAxis xAxi = new XAxis().setType(AxisType.DATETIME);
		xAxi.setTickInterval(7 * 24 * 3600 * 1000)
			.setTickWidth(0)
			.setGridLineWidth(1)
			.getLabels().setAlign(HorizontalAlign.LEFT).setX(3).setY(-3);
		chartOptions.getXAxis().add(xAxi);
		
		YAxis yAxi = new YAxis().setShowFirstLabel(false);
		yAxi.getTitle().setText(null);
		yAxi.getLabels().setAlign(HorizontalAlign.LEFT).setX(3).setY(16).setFormat("{value:.,0f}");
		chartOptions.getYAxis().add(yAxi);
		
		yAxi = new YAxis().setLinkedTo(0).setGridLineWidth(0).setOpposite(true).setShowFirstLabel(false);
		yAxi.getTitle().setText(null);
		yAxi.getLabels().setAlign(HorizontalAlign.RIGHT).setX(-3).setY(16).setFormat("{value:.,0f}");
		chartOptions.getYAxis().add(yAxi);
	
		chartOptions.getLegend().setAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.TOP).setBorderWidth(0);
		
		chartOptions.getTooltip().setShared(true).setCrosshairs(true);
		
		chartOptions.getPlotOptions().getSeries().setCursor(Cursor.POINTER).getMarker().setLineWidth(1);
		
		SeriesLine seriesLine = new SeriesLine();
		
		seriesLine.setName("Users").setLineWidth(4).getMarker().setRadius(4);
		seriesLine.setDataAsArrayObject(getSeriesData(2));
		chartOptions.getSeries().add(seriesLine);
		
		seriesLine = new SeriesLine();
		seriesLine.setName("Sessions");
		seriesLine.setDataAsArrayObject(getSeriesData(1));
		chartOptions.getSeries().add(seriesLine);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Data> getSeriesData(int series) {
		ArrayList<Data> array = new ArrayList<Data>();
		SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
		formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
		
		try {
			if (series == 1) {
				array.add(new Data().setX((formatter.parse("12/18/17")).getTime()).setY(48351));
				array.add(new Data().setX((formatter.parse("12/19/17")).getTime()).setY(51499));
				array.add(new Data().setX((formatter.parse("12/20/17")).getTime()).setY(53359));
				array.add(new Data().setX((formatter.parse("12/21/17")).getTime()).setY(49018));
				array.add(new Data().setX((formatter.parse("12/22/17")).getTime()).setY(43332));
				array.add(new Data().setX((formatter.parse("12/23/17")).getTime()).setY(33419));
				array.add(new Data().setX((formatter.parse("12/24/17")).getTime()).setY(30020));
				array.add(new Data().setX((formatter.parse("12/25/17")).getTime()).setY(33183));
				array.add(new Data().setX((formatter.parse("12/26/17")).getTime()).setY(38782));
				array.add(new Data().setX((formatter.parse("12/27/17")).getTime()).setY(42566));
				array.add(new Data().setX((formatter.parse("12/28/17")).getTime()).setY(39972));
				array.add(new Data().setX((formatter.parse("12/29/17")).getTime()).setY(40414));
				array.add(new Data().setX((formatter.parse("12/30/17")).getTime()).setY(33565));
				array.add(new Data().setX((formatter.parse("12/31/17")).getTime()).setY(30738));
				array.add(new Data().setX((formatter.parse("01/01/18")).getTime()).setY(32822));
				array.add(new Data().setX((formatter.parse("01/02/18")).getTime()).setY(42081));
				array.add(new Data().setX((formatter.parse("01/03/18")).getTime()).setY(45652));
				array.add(new Data().setX((formatter.parse("01/04/18")).getTime()).setY(49572));
				array.add(new Data().setX((formatter.parse("01/05/18")).getTime()).setY(47936));
				array.add(new Data().setX((formatter.parse("01/06/18")).getTime()).setY(37539));
				array.add(new Data().setX((formatter.parse("01/07/18")).getTime()).setY(38527));
				array.add(new Data().setX((formatter.parse("01/08/18")).getTime()).setY(46847));
				array.add(new Data().setX((formatter.parse("01/09/18")).getTime()).setY(51286));
				array.add(new Data().setX((formatter.parse("01/10/18")).getTime()).setY(53245));
				array.add(new Data().setX((formatter.parse("01/11/18")).getTime()).setY(50733));
				array.add(new Data().setX((formatter.parse("01/12/18")).getTime()).setY(49046));
				array.add(new Data().setX((formatter.parse("01/13/18")).getTime()).setY(37106));
				array.add(new Data().setX((formatter.parse("01/14/18")).getTime()).setY(33218));
				array.add(new Data().setX((formatter.parse("01/15/18")).getTime()).setY(44192));
				array.add(new Data().setX((formatter.parse("01/16/18")).getTime()).setY(49612));
				array.add(new Data().setX((formatter.parse("01/17/18")).getTime()).setY(50285));
			}
			else if (series == 2) {
				array.add(new Data().setX((formatter.parse("12/18/17")).getTime()).setY(40585));
				array.add(new Data().setX((formatter.parse("12/19/17")).getTime()).setY(43039));
				array.add(new Data().setX((formatter.parse("12/20/17")).getTime()).setY(44926));
				array.add(new Data().setX((formatter.parse("12/21/17")).getTime()).setY(41256));
				array.add(new Data().setX((formatter.parse("12/22/17")).getTime()).setY(36844));
				array.add(new Data().setX((formatter.parse("12/23/17")).getTime()).setY(28955));
				array.add(new Data().setX((formatter.parse("12/24/17")).getTime()).setY(26113));
				array.add(new Data().setX((formatter.parse("12/25/17")).getTime()).setY(28433));
				array.add(new Data().setX((formatter.parse("12/26/17")).getTime()).setY(32687));
				array.add(new Data().setX((formatter.parse("12/27/17")).getTime()).setY(35689));
				array.add(new Data().setX((formatter.parse("12/28/17")).getTime()).setY(33656));
				array.add(new Data().setX((formatter.parse("12/29/17")).getTime()).setY(34559));
				array.add(new Data().setX((formatter.parse("12/30/17")).getTime()).setY(29197));
				array.add(new Data().setX((formatter.parse("12/31/17")).getTime()).setY(26495));
				array.add(new Data().setX((formatter.parse("01/01/18")).getTime()).setY(28291));
				array.add(new Data().setX((formatter.parse("01/02/18")).getTime()).setY(35472));
				array.add(new Data().setX((formatter.parse("01/03/18")).getTime()).setY(38363));
				array.add(new Data().setX((formatter.parse("01/04/18")).getTime()).setY(41645));
				array.add(new Data().setX((formatter.parse("01/05/18")).getTime()).setY(40268));
				array.add(new Data().setX((formatter.parse("01/06/18")).getTime()).setY(32846));
				array.add(new Data().setX((formatter.parse("01/07/18")).getTime()).setY(33560));
				array.add(new Data().setX((formatter.parse("01/08/18")).getTime()).setY(39327));
				array.add(new Data().setX((formatter.parse("01/09/18")).getTime()).setY(42947));
				array.add(new Data().setX((formatter.parse("01/10/18")).getTime()).setY(44179));
				array.add(new Data().setX((formatter.parse("01/11/18")).getTime()).setY(41938));
				array.add(new Data().setX((formatter.parse("01/12/18")).getTime()).setY(40964));
				array.add(new Data().setX((formatter.parse("01/13/18")).getTime()).setY(32176));
				array.add(new Data().setX((formatter.parse("01/14/18")).getTime()).setY(28915));
				array.add(new Data().setX((formatter.parse("01/15/18")).getTime()).setY(37077));
				array.add(new Data().setX((formatter.parse("01/16/18")).getTime()).setY(41477));
				array.add(new Data().setX((formatter.parse("01/17/18")).getTime()).setY(41840));
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}

    	return array;
    }
}
