package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import javax.ws.rs.client.WebTarget;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesHeatmap;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;
import com.webonlineapp.hyjavachartsdemo7flow.util.DateUtil;

public class LargeHeatMap extends DemoChartBase {
	private static final long serialVersionUID = 1623174014186988429L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.HEATMAP)
			.setMargin(Arrays.asList(60, 10, 80, 50));

		chartOptions.getBoost().setUseGPUTranslations(true);

		chartOptions.getTitle().setText("Highcharts heat map")
			.setAlign(HorizontalAlign.LEFT)
			.setX(40);

		chartOptions.getSubtitle().setText("Temperature variation by day and hour through 2017")
			.setAlign(HorizontalAlign.LEFT)
			.setX(40);
		
		chartOptions.getXAxisSingle()
			.setType(AxisType.DATETIME)
			.setMin(DateUtil.toMilli(2017, 1, 1))
			.setMax(DateUtil.toMilli(2018, 1, 1))
			.setShowLastLabel(false)
			.setTickLength(16)
			.getLabels()
				.setAlign(HorizontalAlign.LEFT)
				.setX(5)
				.setY(14)
				.setFormat("{value:%B}");
		
		chartOptions.getYAxisSingle().getTitle().setText(null);
		chartOptions.getYAxisSingle()
			.setMinPadding(0)
			.setMaxPadding(0)
			.setStartOnTick(false)
			.setEndOnTick(false)
			.setTickPositions(Arrays.asList(0, 6, 12, 18, 24))
			.setTickWidth(1)
			.setMin(0)
			.setMax(23)
			.setReversed(true)
			.getLabels().setFormat("{value}:00");
		
		chartOptions.getColorAxisSingle()
			.setMin(-15)
			.setMax(25)
			.setStartOnTick(false)
			.setEndOnTick(false)
			.setStops(Arrays.asList(
				new Stop(0, new Color("#3060cf")), 
				new Stop(0.5, new Color("#fffbbc")),
				new Stop(0.9, new Color("#c4463a")),
				new Stop(1, new Color("#c4463a"))))
			.getLabels().setFormat("{value}℃");
		
		SeriesHeatmap seriesHeatmap = new SeriesHeatmap();
		seriesHeatmap.setBoostThreshold(100)
			.setBorderWidth(0)
			.setNullColor(new Color("#EFEFEF"))
			.setColsize(24 * 36e5)
			.getTooltip().setHeaderFormat("Temperature<br/>")
				.setPointFormat("{point.x:%e %b, %Y} {point.y}:00: <b>{point.value} ℃</b>");
		seriesHeatmap.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesHeatmap);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Object> getSeriesData() {
		ArrayList<Object> array = new ArrayList<Object>();
		
		// REST service returns CSV heatmap data in format Date,Time,Temperature
		WebTarget webTarget = new RestService().getWebTarget();
		String heatMapData = webTarget.path("LargeHeatMapCSVData").request().get(String.class);

		String[] dataRows = heatMapData.split("\n");
		
		for(int i = 1; i < dataRows.length; i++) {
			String[] rowElements = dataRows[i].split(",");

			array.add(new ArrayList<Object>(Arrays.asList(
					DateUtil.toMilli(Integer.parseInt(rowElements[0].substring(0, 4)), 
							Integer.parseInt(rowElements[0].substring(5, 7)), 
							Integer.parseInt(rowElements[0].substring(8, 10))),
					Integer.parseInt(rowElements[1]),
					Double.parseDouble(rowElements[2]))));
		}

    	return array;
    }
}
